//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef CARTRIDGEE7_HXX
#define CARTRIDGEE7_HXX

class CartridgeE7;

#include "machine.hxx"
#include "Cart.hxx"

/**
  This is the M-Network Bankswitching method (E7).  There are two 2K
  slices, 8 ROM banks, and 2K of RAM.  The RAM is broken into two
  1K pieces.  One 1K piece goes into slice 0 if selected and the other
  one is broken into four 256-byte parts.

  @author  Bradford W. Mott
  @version $Id: CartE7.hxx,v 1.2 1997/05/17 19:00:03 bwmott Exp $
*/
class CartridgeE7 : public Cartridge
{
  public:
    /// Constructor
    CartridgeE7(System& system, uByte* image);
 
    /// Destructor
    virtual ~CartridgeE7();

    /// Reset to power on state
    void reset();

    /// Answer the byte at the given address
    virtual uByte peek(uWord addr);

    /// Store value in the given address
    virtual void poke(uWord addr, uByte value);

  private:
    // Addressing offsets for each of the 2 2K slices in the ROM image
    uWord myImageOffset[2];

    // Addressing offset for the 4 256 byte RAM slices
    uWord myRAMOffset;

    // 16 ROM image of cartridge and 1K for RAM available from 0x0000 to 0x07FF
    uByte myImage[9 * 2048];

    // Four 256 byte RAMs available from 0x0800 to 0x09FF 
    uByte myRAM[1024];
};
#endif

