//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef CARTRIDGEF6SC_HXX
#define CARTRIDGEF6SC_HXX

class CartridgeF6SC;

#include "machine.hxx"
#include "Cart.hxx"

/**
  The 16K cartridge class used by Atari 'Super-chip' cartridges.  There
  are 4 4K banks and 128-bytes of RAM.

  @author  Bradford W. Mott
  @version $Id: CartF6SC.hxx,v 1.2 1997/05/17 19:00:04 bwmott Exp $
*/
class CartridgeF6SC : public Cartridge
{
  public:
    /// Constructor
    CartridgeF6SC(System& system, uByte* image);
 
    /// Destructor
    virtual ~CartridgeF6SC();

    /// Reset to power on state
    void reset();

    /// Answer the byte at the given address
    virtual uByte peek(uWord addr);

    /// Store value in the given address
    virtual void poke(uWord addr, uByte value);

  private:
    // Addressing offset in ROM image
    uWord myImageOffset;

    // Addressing offset in RAM (always zero)
    uWord myRAMOffset;

    // 16K ROM Image of the cartridge
    uByte myImage[16384];

    // 128 bytes of RAM
    uByte myRAM[128]; 
};
#endif

