//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

/**
  The 8K cartridge class used by Atari (and most others).  There
  are 2 4K banks.

  @author  Bradford W. Mott
  @version $Id: CartF8.cxx,v 1.2 1997/05/17 19:00:04 bwmott Exp $
*/

#include "CartF8.hxx"
#include "System.hxx"

//============================================================================
// Constructor
//============================================================================
CartridgeF8::CartridgeF8(System& system, uByte* image)
    : Cartridge(system),
      myImageOffset(0)
{
  uWord addr;

  // Copy the ROM image into my buffer
  for(addr = 0; addr < 8192; ++addr)
    myImage[addr] = image[addr];

  // Map all of my addresses in the system
  for(addr = 0; addr < 8192; ++addr)
  {
    if(addr & 0x1000)
    {
      if(((addr & 0x0fff) == 0x0ff8) || ((addr & 0x0fff) == 0x0ff9))
      {
        mySystem.mapPeek(addr, *this);
      }
      else
      {
        mySystem.mapPeek(addr, *this, 
            &myImage[addr & 0x0fff], &myImageOffset);
      }
      mySystem.mapPoke(addr, *this);
    }
  }

  // Reset myself
  reset();
}
 
//============================================================================
// Destructor
//============================================================================
CartridgeF8::~CartridgeF8()
{
}

//============================================================================
// Answer the byte at the given address
//============================================================================
uByte CartridgeF8::peek(uWord addr)
{
  // Switch banks if necessary
  switch(addr & 0x0fff)
  {
    case 0x0ff8:
      // Set the current bank to the lower 4k bank
      myImageOffset = 0;
      return myImage[(addr & 0x0fff)];

    case 0x0ff9:
      // Set the current bank to the upper 4k bank
      myImageOffset = 4096;
      return myImage[(addr & 0x0fff) + 4096];

    default:
      return myImage[(addr & 0x0fff)];
  }
}

//============================================================================
// Store value in the given address
//============================================================================
void CartridgeF8::poke(uWord addr, uByte value)
{
  // Switch banks if necessary
  switch(addr & 0x0fff)
  {
    case 0x0ff8:
      // Set the current bank to the lower 4k bank
      myImageOffset = 0;
      break;

    case 0x0ff9:
      // Set the current bank to the upper 4k bank
      myImageOffset = 4096;
      break;

    default:
      break;
  }
}

//============================================================================
// Reset to my power on state
//============================================================================
void CartridgeF8::reset()
{
  // Start execution in the upper 4k bank
  myImageOffset = 4096;
}
 
