/********************************************************************************
 * Copyright (c) Erik Kunze 1995, 1996, 1997
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef lint
static char rcsid[] = "$Id: debug.c,v 3.5 1997/10/31 20:54:15 erik Rel $";
#endif

#include <stdio.h>
#include "z80.h"
#include "resource.h"
#include "mem.h"
#include "dis.h"
#include "debug.h"


#ifdef DEBUG
static void dumpCpuState(void);
#endif



#ifdef DEBUG
static void
dumpCpuState(void)
{
	(void)fprintf(stderr, "Z80 CPU State\n-------------\n");
	(void)fprintf(stderr, "  AF  = %04X\t\tAF' = %04X\n", AF, AF1);
	(void)fprintf(stderr, "  BC  = %04X\t\tBC' = %04X\n", BC, BC1);
	(void)fprintf(stderr, "  DE  = %04X\t\tDE' = %04X\n", DE, DE1);
	(void)fprintf(stderr, "  HL  = %04X\t\tHL' = %04X\n", HL, HL1);
	(void)fprintf(stderr, "  IX  = %04X\t\tIY  = %04X\n\n",	IX, IY);
	(void)fprintf(stderr, "  PC  = %04X\t\tSP  = %04X\n", PC, SP);
	(void)fprintf(stderr, "   R  = %02X\t\t I  = %02X\n\n", R, I);
	(void)fprintf(stderr, "  interrupts %s, IM%d\n",
				  IFF1 ? "enabled" : "disabled", IM);
	(void)fprintf(stderr, "  FLAGS: C=%d N=%d P/V=%d H=%d Z=%d S=%d\n\n",
				  TST(C_FLAG), TST(N_FLAG), TST(P_FLAG),
				  TST(H_FLAG), TST(Z_FLAG), TST(S_FLAG));
}
#endif

#ifdef DEBUG
void
DebugZ80(void)
{
	char buf[80];
	uns16 addr;
	int i;
	if (GETCFG(debug) & D_CPU)
	{

		dumpCpuState();
	}
	if (GETCFG(debug) & D_SYSVAR)
	{

		for(addr = 0x5c00; addr < 0x5d00;)
		{
			(void)fprintf(stderr, "%04x ", addr);
			for (i = 0; i < 16; i++)
			{
				(void)fprintf(stderr," %02x", RD_BYTE(addr++));
			}
			(void)putc('\n', stderr);
		}
		(void)putc('\n', stderr);
	}
	if (GETCFG(debug) & D_MNEMO)
	{

		(void)Disassemble(buf, PC);
		(void)fprintf(stderr, "%04X\t%s\n", PC, buf);
		if (GETCFG(debug) & (D_CPU | D_SYSVAR))
		{
			(void)putc('\n', stderr);
		}
	}
}
#endif

