/********************************************************************************
 * Copyright (c) Erik Kunze 1995, 1996
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef _XZX_IO_H
#define _XZX_IO_H
/* $Id: io.h,v 3.9 1997/07/25 16:21:47 erik Rel $ */
#include "z80.h"


#define P_ULA					0xfe
#define B_ULA					0x01
#define B_BORDER				0x07
#define B_MIC					0x08
#define B_SPEAKER				0x10
#define B_KEYBOARD				0x1f
#define B_EAR					0x40

#define P_PRINTER				0xfb
#define B_PRINTER				0x04
#define B_SPEED					0x02
#define B_MOTOR					0x04
#define B_STYLE					0x80
#define B_ENCODER				0x01
#define B_PRESENT				0x40
#define B_PAPER					0x80

#define P_KEMPSTON				0x1f
#define B_KEMPSTON				0x20
#define B_RIGHT 				0x01
#define B_LEFT  				0x02
#define B_DOWN  				0x04
#define B_UP   				    0x08
#define B_FIRE 				    0x10

#define P_128					0xfd

#define P_BANK128				0x7ffd
#define B_BANK128				0x8002
#define B_SELRAM				0x07
#define B_SELSCREEN				0x08
#define B_SELROM				0x10
#define B_PAGING				0x20
#define PAGING_DISABLED(port)	((port) & B_PAGING)

#define P_BANK3					0x1ffd
#define B_BANK3					0xe002
#define B_SPECIAL				0x01
#define B_SELRAM3				0x06
#define B_SELROM3				0x04
#define B_DISK					0x08
#define B_STROBE				0x10
#define EXTENDED_RAM(port)		((port) & B_SPECIAL)

#define P_CENTRONICS			0x0ffd
#define P_FDCCONTROL			0x2ffd
#define P_FDCDATA				0x3ffd
#define B_BUSY					0x01

#define P_SNDCONTROL			0xfffd
#define P_SNDDATA				0xbffd
#define B_SNDCHIP				0x8002
#define B_SNDCONTROL			0x4000
#define B_SNDDATA				B_SNDCONTROL

#define P_MDCONTROL				0xef
#define P_MDDATA				0xe7
#define B_IF1					0x0010
#define B_MDCONTROL				0x0008
#define B_MDDATA				B_MDCONTROL

#define P_MF128IN				0xbf
#define P_MF128OUT				0x3f

#define P_SINCLAIR1				0xeffe
#define P_SINCLAIR2				0xf7fe

#define P_FULCONTROL			0x3f
#define P_FULDATA				0x5f
#define P_FULJOY				0x7f

#define P_LPRINTON				0xfb
#define P_LPRINTOFF				0x7b
#define B_LPRINT				0x84

#define P_GRAFPADPEN			0xff3f
#define P_GRAFPADX				0xffbf
#define P_GRAFPADY				0xff7f

#ifdef PSEUDO_IO
#define PSEUDO_IO_LOWBYTE		0xbf
#define PSEUDO_STDIN			(0x0000 | PSEUDO_IO_LOWBYTE)
#define PSEUDO_STDOUT			(0x0100 | PSEUDO_IO_LOWBYTE)
#define PSEUDO_STDERR			(0x0200 | PSEUDO_IO_LOWBYTE)
#endif

extern void IoReset(void);
extern void OutBank678(uns8);
extern void OutByte(uns16, uns8);
extern uns8 InByte(uns16);
extern uns8 Last0x7FFD, Last0x1FFD, Last0xFFFD;
extern int ScreenSelect;
extern uns8 KeyPorts[9], InPorts[256];
extern int BasicRom;
extern uns8 LastBorderColor;
extern unsigned char PSG[16];
#endif

