;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                       ;;
;;;                Centre for Speech Technology Research                  ;;
;;;                     University of Edinburgh, UK                       ;;
;;;                       Copyright (c) 1996,1997                         ;;
;;;                        All Rights Reserved.                           ;;
;;;                                                                       ;;
;;;  Permission to use, copy, modify, distribute this software and its    ;;
;;;  documentation for research, educational and individual use only, is  ;;
;;;  hereby granted without fee, subject to the following conditions:     ;;
;;;   1. The code must retain the above copyright notice, this list of    ;;
;;;      conditions and the following disclaimer.                         ;;
;;;   2. Any modifications must be clearly marked as such.                ;;
;;;   3. Original authors' names are not deleted.                         ;;
;;;  This software may not be used for commercial purposes without        ;;
;;;  specific prior written permission from the authors.                  ;;
;;;                                                                       ;;
;;;  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ;;
;;;  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ;;
;;;  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ;;
;;;  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ;;
;;;  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ;;
;;;  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ;;
;;;  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ;;
;;;  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ;;
;;;  THIS SOFTWARE.                                                       ;;
;;;                                                                       ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;   A tree to predict zcore durations build from gsw 450 (timit)
;;;   doesn't use actual phonemes so it can have better generalizations
;;;

;; pre Sue's changes to mrpa_phones
;; RMSE 0.79102 Correlation is 0.610184 Mean (abs) Error 0.605081 (0.509517)
;; Post with balance
;; train test spit --stop 19 --balance 16
;; RMSE 0.841861 Correlation is 0.526064 Mean (abs) Error 0.646614 (0.539288)
;; on full data
;; RMSE 0.784032 Correlation is 0.619165 Mean (abs) Error 0.602819 (0.501332)

(set! gsw_duration_cart_tree
'
((name is #)
 ((emph_sil is +)
  ((0.0 -0.5))
  ((p.Syllable.Word.pbreak is BB)
   ((0.0 2.0))  
   ((0.0 0.0))))
((n.ph_vlng is a)
 ((ph_cplace is v)
  ((Syllable.syl_in < 1.8)
   ((0.471879 -0.225))
   ((p.ph_vc is +)
    ((Syllable.next_accent < 1.5)
     ((0.67174 -0.28812))
     ((0.703706 -0.696773)))
    ((0.53137 -0.3064))))
  ((p.ph_vheight is 3)
   ((Syllable.syl_in < 1.6)
    ((0.463093 -0.48725))
    ((ph_ctype is s)
     ((0.43958 -0.343886))
     ((Syllable.syl_out < 7)
      ((Syllable.accented is 0)
       ((0.81432 0.0866))
       ((0.582229 -0.470737)))
      ((0.63987 -0.480762)))))
   ((p.ph_vlng is d)
    ((Syllable.asyl_out < 2.4)
     ((ph_cplace is a)
      ((0.427497 -0.42155))
      ((Syllable.ssyl_out < 1.5)
       ((0.758205 0.334852))
       ((0.595296 -0.289042))))
     ((0.440116 -0.337111)))
    ((ph_cplace is p)
     ((Syllable.ssyl_out < 4)
      ((Syllable.syl_in < 7)
       ((0.449948 -0.861741))
       ((Syllable.syl_out < 1.5)
        ((0.728226 0.0157))
        ((0.611683 -0.58925))))
      ((0.367613 -0.62585)))
     ((ph_cvox is -)
      ((p.ph_vlng is s)
       ((0.362519 -0.436281))
       ((Syllable.next_accent < 2.4)
        ((Syllable.asyl_in < 0.8)
         ((0.583103 0.0789))
         ((p.ph_ctype is f)
          ((ph_cplace is a)
           ((0.416674 -0.270864))
           ((0.462632 -0.918)))
          ((Syllable.last_accent < 2.1)
           ((Syllable.syl_in < 3.4)
            ((0.622528 -0.542522))
            ((p.ph_cvox is -)
             ((0.636441 -0.131808))
             ((Syllable.ssyl_out < 1.2)
              ((0.726114 -0.0540526))
              ((0.778401 -0.5055)))))
           ((0.580272 -0.557316)))))
        ((Syllable.syl_in < 6)
         ((0.5512 -0.5893))
         ((0.440733 -0.256947)))))
      ((p.ph_ctype is n)
       ((ph_cplace is d)
        ((0.395356 -0.7585))
        ((Syllable.syl_break is 1)
         ((0.823979 -0.402233))
         ((0.62483 -0.897571))))
       ((Syllable.ssyl_out < 1)
        ((pos_in_syl < 0.3)
         ((0.664777 -0.56675))
         ((0.727513 -0.34065)))
        ((ph_ctype is n)
         ((Syllable.next_accent < 2.4)
          ((Syllable.ssyl_out < 3.4)
           ((Syllable.ssyl_out < 1.2)
            ((0.572116 -0.52645))
            ((0.889981 -0.256815)))
           ((0.498526 -0.7951)))
          ((0.471074 -0.86828)))
         ((ph_ctype is s)
          ((pos_in_syl < 1.5)
           ((0.748617 0.0354074))
           ((0.525421 -0.599762)))
          ((ph_cplace is l)
           ((0.690745 -0.539667))
           ((Syllable.asyl_out < 4.5)
            ((Syllable.ssyl_out < 6.4)
             ((Syllable.ssyl_out < 5.5)
              ((ph_vfront is 1)
               ((0.71591 -0.39))
               ((ph_vlng is d)
                ((0.783303 0.318))
                ((p.ph_vheight is 1)
                 ((Syllable.syl_out < 5.4)
                  ((0.678727 -0.0803158))
                  ((0.848572 0.120667)))
                 ((p.ph_vlng is a)
                  ((Syllable.next_accent < 1.2)
                   ((0.826745 0.00630769))
                   ((0.667945 -0.431684)))
                  ((p.ph_cplace is l)
                   ((0.992486 -0.687905))
                   ((ph_cplace is a)
                    ((Syllable.next_accent < 1.5)
                     ((1.08864 -0.444345))
                     ((0.66312 -0.356105)))
                    ((Syllable.accented is 0)
                     ((pp.ph_vc is 0)
                      ((0.998943 -0.0412222))
                      ((p.ph_cplace is a)
                       ((1.18904 -0.33048))
                       ((1.24613 0.436037))))
                     ((0.864051 0.231333)))))))))
              ((0.759892 -0.3285)))
             ((0.749299 -0.414654)))
            ((Syllable.syl_out < 12.8)
             ((0.66598 -0.29581))
             ((0.814024 -0.175611))))))))))))))
 ((Syllable.n.syl_break is 4)
  ((ph_vheight is 3)
   ((p.ph_ctype is f)
    ((0.419446 0.0293158))
    ((Syllable.last_accent < 2.4)
     ((0.72527 -0.0887838))
     ((0.614218 0.290952))))
   ((n.ph_ctype is n)
    ((Syllable.stress is 0)
     ((Syllable.asyl_in < 3.2)
      ((0.609328 -0.637211))
      ((0.513275 -0.430263)))
     ((ph_vfront is 1)
      ((0.541053 -0.0191429))
      ((0.729346 -0.042125))))
    ((Syllable.last_accent < 4.8)
     ((p.ph_vlng is l)
      ((n.ph_vheight is 1)
       ((0.708962 0.0873182))
       ((0.793732 0.43025)))
      ((ph_ctype is n)
       ((n.ph_vc is +)
        ((0.546731 -0.381))
        ((n.ph_ctype is f)
         ((0.576244 0.726579))
         ((0.808421 0.275031))))
       ((ph_vlng is s)
        ((p.ph_ctype is r)
         ((0.662589 -0.236043))
         ((Syllable.accented is 0)
          ((nn.ph_vc is +)
           ((0.879587 0.179214))
           ((0.623964 -0.325174)))
          ((0.744503 0.438179))))
        ((n.ph_ctype is l)
         ((0.811402 -0.0367297))
         ((Syllable.ssyl_in < 7.7)
          ((p.ph_vlng is s)
           ((Syllable.syl_in < 11)
            ((ph_cplace is a)
             ((0.928329 0.39024))
             ((0.613708 -0.33316)))
            ((0.554636 -0.3258)))
           ((p.ph_cplace is p)
            ((0.71486 -0.0918519))
            ((p.ph_ctype is l)
             ((0.830622 0.11863))
             ((n.ph_cplace is p)
              ((0.850275 0.421407))
              ((ph_ctype is f)
               ((Syllable.syl_break is 0)
                ((p.ph_cvox is +)
                 ((0.549678 0.19055))
                 ((0.859535 0.335471)))
                ((0.612178 -0.51596)))
               ((p.ph_vlng is a)
                ((ph_cplace is l)
                 ((0.477033 0.682158))
                 ((1.04396 0.40897)))
                ((Syllable.last_accent < 3.2)
                 ((Syllable.last_accent < 2.1)
                  ((n.ph_vheight is 1)
                   ((0.889762 -0.228459))
                   ((n.ph_vlng is s)
                    ((0.882852 -0.0724091))
                    ((n.ph_vlng is d)
                     ((1.02814 0.472348))
                     ((p.ph_ctype is s)
                      ((1.09281 0.397739))
                      ((Syllable.syl_in < 10.2)
                       ((Syllable.ssyl_in < 4.5)
                        ((1.42801 0.422793))
                        ((1.14492 -0.307158)))
                       ((0.98813 -0.0826842)))))))
                  ((0.794842 0.0436897)))
                 ((0.853128 -0.0616316)))))))))
          ((ph_cvox is +)
           ((0.639669 0.172947))
           ((0.953738 0.355182))))))))
     ((p.ph_vheight is 2)
      ((0.575788 0.246045))
      ((n.ph_ctype is s)
       ((0.5881 -0.329789))
       ((Syllable.syl_in < 12)
        ((0.830273 0.12775))
        ((0.7129 -0.14205))))))))
  ((n.ph_vheight is 1)
   ((pos_in_syl < 2.1)
    ((ph_ctype is l)
     ((p.ph_cvox is -)
      ((Syllable.accented is 0)
       ((0.470482 -0.817667))
       ((0.456954 -1.16386)))
      ((pos_in_syl < 1.2)
       ((Syllable.asyl_out < 0.6)
        ((0.548559 -0.415211))
        ((Syllable.p.syl_break is 0)
         ((0.720169 -0.522065))
         ((0.64578 0.0145))))
       ((0.430284 -0.482741))))
     ((p.ph_vlng is s)
      ((ph_ctype is n)
       ((Syllable.ssyl_out < 2.4)
        ((0.391378 -1.05238))
        ((0.667924 -0.789459)))
       ((Syllable.ssyl_in < 6)
        ((n.ph_vlng is s)
         ((Syllable.syl_out < 8.8)
          ((Syllable.syl_out < 4.4)
           ((0.583802 -0.7767))
           ((0.810324 -0.36475)))
          ((0.453629 -0.52644)))
         ((0.611733 0.0971)))
        ((0.41003 -0.150105))))
      ((pos_in_syl < 1.2)
       ((ph_vc is +)
        ((Syllable.asyl_in < 2.5)
         ((Syllable.n.syl_break is 0)
          ((0.672102 -0.434304))
          ((0.83345 0.156842)))
         ((0.598491 -0.401238)))
        ((syl_final is 0)
         ((p.ph_vlng is a)
          ((Syllable.stress is 0)
           ((0.641124 0.4236))
           ((Syllable.next_accent < 2.4)
            ((Syllable.syl_break is 1)
             ((0.653825 0.7527))
             ((0.80778 0.808235)))
            ((0.594323 1.01552))))
          ((pos_in_syl < 0.1)
           ((p.ph_vheight is 1)
            ((0.724618 0.329914))
            ((Syllable.ssyl_out < 6.6)
             ((Syllable.stress is 0)
              ((Syllable.ssyl_out < 5.4)
               ((p.ph_cplace is v)
                ((0.639637 -0.633963))
                ((p.ph_ctype is n)
                 ((0.671499 -0.61713))
                 ((nn.ph_vc is +)
                  ((p.ph_cvox is -)
                   ((0.788839 0.0726316))
                   ((0.732297 -0.287368)))
                  ((Syllable.asyl_in < 2.1)
                   ((ph_cplace is l)
                    ((0.839239 -0.793636))
                    ((p.ph_cplace is a)
                     ((0.843355 -0.6139))
                     ((ph_ctype is f)
                      ((0.99528 -0.460105))
                      ((1.10176 0.285696)))))
                   ((0.817772 -0.495152))))))
               ((0.534875 -0.897316)))
              ((ph_cplace is v)
               ((0.7925 0.5503))
               ((ph_ctype is n)
                ((0.824704 0.101174))
                ((Syllable.next_accent < 3.6)
                 ((Syllable.asyl_out < 3.6)
                  ((ph_cplace is p)
                   ((0.860023 0.32816))
                   ((Syllable.syl_break is 0)
                    ((Syllable.ssyl_in < 3.6)
                     ((1.02265 0.119563))
                     ((0.617138 -0.0784)))
                    ((ph_cplace is a)
                     ((0.977686 1.03906))
                     ((1.09445 0.256767)))))
                  ((0.86739 0.0620526)))
                 ((0.812427 0.787857))))))
             ((0.739037 0.00797561))))
           ((n.ph_vlng is l)
            ((p.ph_cvox is -)
             ((Syllable.syl_out < 5.7)
              ((0.687132 -0.172517))
              ((0.585569 -0.596)))
             ((0.730011 0.27281)))
            ((0.624143 -0.790895)))))
         ((ph_ctype is n)
          ((0.352193 -0.765632))
          ((ph_cvox is -)
           ((Syllable.asyl_out < 1.2)
            ((0.435073 0.11575))
            ((0.716712 0.350579)))
           ((Syllable.accented is 0)
            ((0.785087 -0.0239714))
            ((0.541347 -0.599808)))))))
       ((p.ph_vheight is 1)
        ((0.438276 -0.325357))
        ((Syllable.syl_break is 1)
         ((0.595697 -0.256257))
         ((n.ph_vlng is s)
          ((ph_cvox is -)
           ((0.571996 -0.260233))
           ((0.60531 -0.716905)))
          ((ph_cvox is -)
           ((0.741052 0.491789))
           ((0.812418 -0.0546818)))))))))
    ((Syllable.syl_in < 9)
     ((Syllable.syl_break is 0)
      ((n.ph_vlng is s)
       ((p.ph_vheight is 1)
        ((0.466773 -0.8325))
        ((0.567597 -0.38819)))
       ((0.731281 0.133375)))
      ((0.45329 -0.497867)))
     ((0.465017 -0.787286))))
   ((n.ph_ctype is n)
    ((ph_ctype is f)
     ((p.ph_vheight is 1)
      ((0.354668 -0.438455))
      ((Syllable.syl_in < 8)
       ((ph_cvox is -)
        ((0.681239 -0.0766875))
        ((0.617282 -0.6143)))
       ((0.502199 -0.291045))))
     ((p.ph_vheight is 1)
      ((Syllable.syl_out < 8.5)
       ((n.ph_cplace is a)
        ((0.776773 -0.391412))
        ((0.746215 0.0497143)))
       ((0.576924 -0.391789)))
      ((p.ph_ctype is l)
       ((nn.ph_vc is +)
        ((0.444334 -0.483636))
        ((Syllable.next_accent < 0.5)
         ((0.664042 -0.262238))
         ((0.779106 0.212071))))
       ((p.ph_cplace is b)
        ((ph_vlng is a)
         ((0.521518 -0.234316))
         ((Syllable.stress is 0)
          ((0.616931 -0.504632))
          ((0.750213 0.0690968))))
        ((p.ph_ctype is n)
         ((Syllable.accented is 0)
          ((Syllable.syl_break is 0)
           ((0.464158 -0.2909))
           ((Syllable.asyl_in < 3.5)
            ((Syllable.asyl_out < 2.4)
             ((Syllable.ssyl_out < 1.2)
              ((1.06677 0.594632))
              ((0.870792 0.213895)))
             ((0.77388 -0.0128)))
            ((0.623088 0.162909))))
          ((0.516668 -0.231667)))
         ((Syllable.ssyl_in < 7)
          ((ph_vlng is a)
           ((p.ph_cplace is v)
            ((0.506218 -0.812405))
            ((p.ph_cplace is d)
             ((0.533164 -0.460643))
             ((pos_in_syl < 0.2)
              ((p.ph_ctype is f)
               ((p.ph_cvox is -)
                ((0.501216 -0.664038))
                ((0.487635 -0.135368)))
               ((Syllable.ssyl_in < 3.6)
                ((p.ph_cplace is a)
                 ((0.559639 -0.0615))
                 ((1.18567 0.438565)))
                ((0.592669 -0.0887727))))
              ((p.ph_cplace is a)
               ((0.397911 -0.671947))
               ((0.511905 -0.852684))))))
           ((Syllable.ssyl_out < 6)
            ((p.ph_vheight is 2)
             ((0.870685 -0.464382))
             ((Syllable.ssyl_in < 0.6)
              ((0.867575 -0.488))
              ((Syllable.syl_in < 2.4)
               ((p.ph_cvox is +)
                ((0.664985 0.162682))
                ((Syllable.syl_out < 7.4)
                 ((0.67539 -0.121105))
                 ((0.890321 -0.510952))))
               ((p.ph_cplace is v)
                ((Syllable.next_accent < 1.5)
                 ((0.771787 0.452227))
                 ((0.816153 -0.147591)))
                ((Syllable.stress is 0)
                 ((nn.ph_vc is +)
                  ((0.680052 -0.673111))
                  ((Syllable.ssyl_out < 1.5)
                   ((Syllable.ssyl_out < 0.1)
                    ((0.861126 0.26435))
                    ((0.654075 -0.29155)))
                   ((p.ph_cvox is -)
                    ((0.457797 -0.691053))
                    ((0.940047 -0.459696)))))
                 ((Syllable.syl_out < 7.2)
                  ((Syllable.next_accent < 2.1)
                   ((Syllable.syl_break is 0)
                    ((p.ph_cvox is -)
                     ((0.658986 -0.653217))
                     ((0.737811 -0.101484)))
                    ((pos_in_syl < 1.2)
                     ((Syllable.syl_break is 4)
                      ((1.08877 2.21455))
                      ((Syllable.ssyl_out < 2.5)
                       ((1.21994 0.2678))
                       ((1.33161 0.74981))))
                     ((0.832628 0.0824783))))
                   ((0.816888 -0.0388286)))
                  ((0.911941 0.303895))))))))
            ((Syllable.syl_out < 9.8)
             ((0.688081 -0.0954))
             ((Syllable.syl_out < 11.1)
              ((0.608909 -0.0868696))
              ((Syllable.syl_in < 0.8)
               ((0.806971 -0.68155))
               ((0.919612 -0.189806)))))))
          ((ph_vlng is a)
           ((0.663069 -0.369105))
           ((0.821284 -0.0215405)))))))))
    ((n.ph_vlng is d)
     ((ph_ctype is n)
      ((Syllable.p.syl_break is 0)
       ((0.373232 -0.8808))
       ((Syllable.next_accent < 1.5)
        ((Syllable.last_accent < 1.5)
         ((0.747872 -0.189355))
         ((0.631402 -0.693632)))
        ((0.634303 -0.0627))))
      ((ph_vheight is 1)
       ((Syllable.next_accent < 1.6)
        ((0.567461 -0.320909))
        ((0.663003 0.0343)))
       ((p.ph_cplace is l)
        ((ph_cvox is -)
         ((0.587943 0.55975))
         ((Syllable.n.syl_break is 0)
          ((0.684079 0.0946667))
          ((0.669354 -0.454343))))
        ((Syllable.last_accent < 3.5)
         ((Syllable.asyl_out < 4.8)
          ((pp.ph_vc is 0)
           ((0.793292 0.2524))
           ((Syllable.p.syl_break is 0)
            ((Syllable.syl_in < 1.9)
             ((0.631269 0.157579))
             ((Syllable.asyl_out < 2.4)
              ((ph_cplace is a)
               ((Syllable.last_accent < 0.3)
                ((0.614134 0.462632))
                ((0.994584 0.37192)))
               ((0.736163 -0.1932)))
              ((0.579374 0.0421562))))
            ((ph_cplace is b)
             ((0.737702 0.125095))
             ((Syllable.last_accent < 2.1)
              ((nn.ph_vc is +)
               ((Syllable.next_accent < 1.2)
                ((0.789216 -0.18108))
                ((0.766946 0.479429)))
               ((p.ph_ctype is f)
                ((0.872529 0.2176))
                ((p.ph_cvox is +)
                 ((ph_cvox is -)
                  ((0.874151 0.536462))
                  ((Syllable.syl_in < 3.6)
                   ((0.799461 -0.102391))
                   ((0.543909 -0.683158))))
                 ((Syllable.ssyl_out < 1.6)
                  ((0.959699 1.141))
                  ((ph_cplace is l)
                   ((0.900607 0.892286))
                   ((p.ph_vheight is 2)
                    ((1.31551 0.935))
                    ((0.928085 0.0060606))))))))
              ((0.728942 0.517939))))))
          ((Syllable.ssyl_out < 7.6)
           ((0.89767 0.334167))
           ((0.689161 0.257158))))
         ((Syllable.syl_out < 3.3)
          ((0.7694 0.660409))
          ((0.739333 0.1809)))))))
     ((Syllable.syl_out < 11.5)
      ((p.ph_ctype is r)
       ((n.ph_cplace is d)
        ((0.553558 -0.7165))
        ((n.ph_cplace is l)
         ((ph_vlng is l)
          ((0.484151 -0.525217))
          ((Syllable.syl_break is 0)
           ((0.694394 -0.793696))
           ((0.792553 -0.0825312))))
         ((Syllable.syl_break is 0)
          ((p.ph_cplace is p)
           ((Syllable.p.syl_break is 0)
            ((0.32464 -0.9972))
            ((0.423136 -0.60905)))
           ((pos_in_syl < 1.2)
            ((ph_vlng is l)
             ((0.645098 -0.45415))
             ((ph_vfront is 2)
              ((0.713101 -0.0517391))
              ((Syllable.next_accent < 1.4)
               ((0.700748 -0.5563))
               ((0.942816 -0.190591)))))
            ((Syllable.syl_in < 3.9)
             ((0.437406 -0.816571))
             ((0.564717 -0.780939)))))
          ((n.ph_ctype is a)
           ((0.82505 -0.28345))
           ((Syllable.ssyl_out < 4.8)
            ((Syllable.next_accent < 2.1)
             ((Syllable.syl_out < 5.5)
              ((Syllable.ssyl_out < 0.4)
               ((Syllable.syl_in < 10.5)
                ((ph_vfront is 3)
                 ((1.27401 0.550263))
                 ((1.30899 1.39075)))
                ((0.936071 0.655)))
               ((pos_in_syl < 1.2)
                ((ph_vfront is 2)
                 ((0.660784 -0.0663684))
                 ((n.ph_ctype is f)
                  ((0.727156 -0.63365))
                  ((1.16804 0.0049))))
                ((0.544917 -0.3795))))
              ((ph_vlng is a)
               ((0.55273 -0.505789))
               ((Syllable.syl_out < 7.5)
                ((0.615726 -0.616158))
                ((0.986343 -0.137826)))))
             ((Syllable.syl_in < 4.9)
              ((1.08052 -0.258684))
              ((0.6502 -0.562158))))
            ((Syllable.syl_in < 1.2)
             ((0.702229 -0.648158))
             ((0.856595 -0.200172))))))))
       ((n.ph_vfront is 1)
        ((Syllable.syl_in < 11.4)
         ((p.ph_ctype is n)
          ((ph_cvox is +)
           ((0.618423 -0.266952))
           ((0.520498 0.4716)))
          ((ph_cplace is g)
           ((0.74974 -0.29463))
           ((p.ph_vlng is a)
            ((ph_ctype is s)
             ((0.569359 0.771524))
             ((0.820339 0.259065)))
            ((ph_cplace is p)
             ((0.769216 0.109053))
             ((Syllable.last_accent < 3.5)
              ((p.ph_vheight is 1)
               ((0.851277 0.1361))
               ((Syllable.last_accent < 1.2)
                ((Syllable.asyl_out < 3.5)
                 ((p.ph_cvox is +)
                  ((Syllable.ssyl_out < 3.4)
                   ((0.95198 0.8578))
                   ((0.731768 0.0931579)))
                  ((p.ph_cplace is a)
                   ((0.864229 0.0143214))
                   ((Syllable.next_accent < 2.1)
                    ((1.46201 0.399481))
                    ((1.20303 -0.173158)))))
                 ((0.909227 -0.138667)))
                ((p.ph_cvox is -)
                 ((0.550323 -0.6))
                 ((0.891822 0.315083)))))
              ((0.832263 0.068579)))))))
         ((0.667131 -0.240033)))
        ((n.ph_ctype is l)
         ((Syllable.syl_in < 11.9)
          ((p.ph_vlng is s)
           ((Syllable.p.syl_break is 0)
            ((0.604508 -0.754))
            ((0.581889 -0.114409)))
           ((p.ph_cplace is b)
            ((0.739928 0.0211667))
            ((ph_cplace is v)
             ((0.819373 0.650185))
             ((p.ph_vheight is 2)
              ((Syllable.syl_in < 5)
               ((0.594482 -0.0289474))
               ((0.849142 0.0139688)))
              ((Syllable.next_accent < 4.8)
               ((ph_vheight is 3)
                ((0.830787 -0.459471))
                ((Syllable.ssyl_out < 5.6)
                 ((ph_cplace is a)
                  ((0.879158 -0.0199091))
                  ((Syllable.syl_out < 8.8)
                   ((Syllable.asyl_in < 0.4)
                    ((0.864796 -0.476435))
                    ((Syllable.asyl_out < 2.5)
                     ((Syllable.p.syl_break is 0)
                      ((p.ph_cvox is -)
                       ((0.666091 -0.6947))
                       ((1.03713 -0.246842)))
                      ((ph_vfront is 1)
                       ((0.970799 -0.0273))
                       ((Syllable.syl_out < 3.2)
                        ((1.39338 0.911318))
                        ((1.15428 0.236783)))))
                     ((0.748396 -0.053))))
                   ((0.794326 0.0180952))))
                 ((0.839222 -0.164053))))
               ((0.836072 -0.590333)))))))
          ((0.604075 -0.260371)))
         ((Syllable.syl_break is 0)
          ((ph_vlng is a)
           ((p.ph_ctype is s)
            ((pp.ph_vc is +)
             ((0.366565 -0.3541))
             ((0.541109 -0.459286)))
            ((n.ph_cplace is v)
             ((0.577358 -0.00185714))
             ((Syllable.syl_out < 5)
              ((0.608214 0.182762))
              ((Syllable.syl_out < 8.6)
               ((0.750561 0.115871))
               ((0.728675 -0.3262))))))
           ((ph_vlng is d)
            ((Syllable.asyl_out < 3.2)
             ((pos_in_syl < 0.2)
              ((Syllable.p.syl_break is 0)
               ((0.66348 -0.214214))
               ((0.71401 0.373543)))
              ((0.586579 -0.285184)))
             ((0.550143 -0.125842)))
            ((ph_vheight is 1)
             ((Syllable.syl_out < 9.2)
              ((Syllable.accented is 0)
               ((p.ph_ctype is f)
                ((0.501327 -0.474696))
                ((ph_vlng is l)
                 ((0.636132 -0.0774783))
                 ((Syllable.asyl_in < 1.2)
                  ((0.563818 -0.538739))
                  ((Syllable.stress is 0)
                   ((0.702282 -0.6619))
                   ((0.633747 -0.130222))))))
               ((Syllable.n.syl_break is 0)
                ((0.629242 -0.052619))
                ((n.ph_cvox is -)
                 ((0.427247 0.173579))
                 ((0.609633 0.669053)))))
              ((0.455425 -0.00942857)))
             ((ph_vfront is 3)
              ((p.ph_ctype is f)
               ((0.494556 0.174955))
               ((p.ph_ctype is n)
                ((0.527869 -0.09115))
                ((p.ph_cplace is a)
                 ((0.572053 -0.0313077))
                 ((p.ph_cplace is v)
                  ((0.626834 -0.22019))
                  ((p.ph_cvox is -)
                   ((0.628467 -0.486286))
                   ((1.00483 -0.00841177)))))))
              ((n.ph_cvox is -)
               ((Syllable.syl_out < 10.1)
                ((ph_vheight is 2)
                 ((0.491058 -0.18397))
                 ((ph_ctype is s)
                  ((Syllable.asyl_out < 1.5)
                   ((0.402446 -0.935571))
                   ((0.646492 -1.25071)))
                  ((Syllable.syl_out < 9.2)
                   ((ph_cplace is l)
                    ((0.598617 -0.302143))
                    ((Syllable.syl_in < 1.9)
                     ((0.60143 -0.174231))
                     ((Syllable.syl_in < 10.5)
                      ((ph_vc is +)
                       ((0.57679 -0.143105))
                       ((p.ph_vheight is 1)
                        ((0.615852 -0.421714))
                        ((p.ph_vheight is 3)
                         ((0.704148 -0.814))
                         ((Syllable.asyl_out < 2.5)
                          ((ph_ctype is f)
                           ((0.643065 -0.580261))
                           ((1.02137 0.0592903)))
                          ((0.6805 -0.627048))))))
                      ((0.565367 -0.333316)))))
                   ((0.567482 -0.397737)))))
                ((0.456119 -0.841955)))
               ((ph_cplace is b)
                ((Syllable.ssyl_in < 2.4)
                 ((0.500973 0.811895))
                 ((0.692504 0.42037)))
                ((Syllable.ssyl_in < 6)
                 ((Syllable.asyl_out < 4.2)
                  ((Syllable.syl_in < 9.6)
                   ((ph_ctype is l)
                    ((0.755698 -0.28469))
                    ((n.ph_vheight is 3)
                     ((Syllable.syl_in < 2.4)
                      ((0.627608 0.264318))
                      ((0.850173 0.673421)))
                     ((pos_in_syl < 0.4)
                      ((n.ph_vlng is l)
                       ((0.589473 1.00679))
                       ((p.ph_ctype is s)
                        ((0.678915 0.0850323))
                        ((Syllable.last_accent < 2.4)
                         ((Syllable.p.syl_break is 0)
                          ((0.789776 0.2869))
                          ((Syllable.last_accent < 0.2)
                           ((0.808365 0.913231))
                           ((Syllable.ssyl_out < 2.5)
                            ((0.797129 0.765737))
                            ((Syllable.asyl_out < 2.4)
                             ((1.06013 0.532571))
                             ((1.21908 1.10346))))))
                         ((0.790716 0.286905)))))
                      ((Syllable.asyl_out < 0.4)
                       ((0.569698 -0.27905))
                       ((n.ph_ctype is f)
                        ((0.613762 -0.1098))
                        ((n.ph_vlng is s)
                         ((0.659105 -0.703676))
                         ((Syllable.asyl_in < 2.5)
                          ((ph_ctype is n)
                           ((0.70505 0.0152813))
                           ((Syllable.asyl_in < 0.2)
                            ((0.978829 -0.717227))
                            ((p.ph_vheight is 2)
                             ((0.949733 0.4995))
                             ((Syllable.last_accent < 1.6)
                              ((1.07343 -0.376053))
                              ((1.01188 0.185632))))))
                          ((0.754877 -0.4802)))))))))
                   ((0.758716 0.00887097)))
                  ((0.720559 0.381212)))
                 ((ph_cplace is a)
                  ((0.522867 0.0494091))
                  ((Syllable.accented is 0)
                   ((0.837233 -0.456455))
                   ((0.684564 -0.00983333)))))))))))
          ((n.ph_vfront is 3)
           ((pos_in_syl < 1.2)
            ((ph_ctype is n)
             ((Syllable.next_accent < 0.8)
              ((0.677764 -0.123421))
              ((0.664997 -0.382417)))
             ((ph_ctype is l)
              ((0.710073 -0.220385))
              ((pos_in_syl < 0.1)
               ((ph_ctype is f)
                ((pp.ph_vc is +)
                 ((0.809799 0.75655))
                 ((0.573498 1.06245)))
                ((ph_cvox is -)
                 ((0.767733 0.771969))
                 ((Syllable.next_accent < 1.4)
                  ((p.ph_cvox is +)
                   ((1.04888 0.436))
                   ((Syllable.asyl_out < 2.4)
                    ((0.938853 0.56655))
                    ((1.27439 1.39529))))
                  ((1.00261 0.15725)))))
               ((Syllable.asyl_out < 1.2)
                ((0.782623 0.164296))
                ((0.565074 -0.333042))))))
            ((0.626306 -0.298171)))
           ((Syllable.next_accent < 4)
            ((Syllable.syl_break is 1)
             ((n.ph_cplace is d)
              ((Syllable.asyl_in < 0.6)
               ((0.445493 -0.0556818))
               ((Syllable.last_accent < 2.5)
                ((ph_cvox is -)
                 ((0.677349 -0.417414))
                 ((Syllable.stress is 0)
                  ((Syllable.ssyl_out < 2.4)
                   ((Syllable.syl_out < 3.1)
                    ((1.00064 0.452739))
                    ((0.60917 -0.0724286)))
                   ((0.659089 -0.34096)))
                  ((0.675035 0.471905))))
                ((0.541462 -0.11))))
              ((Syllable.asyl_out < 0.8)
               ((n.ph_cplace is b)
                ((0.430119 -0.117333))
                ((ph_vfront is 1)
                 ((0.462568 -0.366875))
                 ((ph_ctype is f)
                  ((0.635419 -0.49095))
                  ((p.ph_cplace is a)
                   ((0.793189 -0.254269))
                   ((p.ph_vlng is s)
                    ((0.897086 -0.363333))
                    ((n.ph_cvox is -)
                     ((0.821842 -0.230958))
                     ((pos_in_syl < 0.2)
                      ((1.15347 0.77815))
                      ((0.691589 0.092381)))))))))
               ((p.ph_cplace is d)
                ((n.ph_cplace is l)
                 ((0.483667 -0.66))
                 ((Syllable.syl_out < 9.2)
                  ((pp.ph_vc is +)
                   ((0.719759 0.458739))
                   ((Syllable.ssyl_out < 1.4)
                    ((0.413807 -0.522211))
                    ((Syllable.n.syl_break is 0)
                     ((0.717432 -0.659958))
                     ((0.84 -0.26108)))))
                  ((0.513382 -0.339333))))
                ((ph_cvox is -)
                 ((pos_in_syl < 2.4)
                  ((p.ph_vlng is d)
                   ((Syllable.p.syl_break is 0)
                    ((0.643523 -1.09133))
                    ((0.640544 -0.550111)))
                   ((p.ph_ctype is s)
                    ((0.792695 -0.480323))
                    ((p.ph_cvox is -)
                     ((Syllable.syl_in < 2.6)
                      ((0.748047 0.193105))
                      ((0.704963 -0.45727)))
                     ((Syllable.syl_in < 8.5)
                      ((Syllable.syl_out < 2.9)
                       ((0.844556 -0.478))
                       ((pos_in_syl < 0.2)
                        ((Syllable.syl_out < 5.4)
                         ((1.21213 0.212174))
                         ((0.860751 0.738684)))
                        ((syl_final is 0)
                         ((Syllable.ssyl_in < 2.5)
                          ((0.602862 -1.3147))
                          ((0.553457 -0.852053)))
                         ((n.ph_ctype is s)
                          ((Syllable.ssyl_in < 1.5)
                           ((0.895949 -0.4761))
                           ((0.389371 -1.08671)))
                          ((ph_cplace is a)
                           ((0.687155 -0.477091))
                           ((1.22546 -0.155658)))))))
                      ((pos_in_syl < 1.2)
                       ((0.716579 -0.23375))
                       ((0.651293 -0.9737)))))))
                  ((syl_final is 0)
                   ((0.496168 -1.34676))
                   ((n.ph_ctype is f)
                    ((0.501471 -0.760545))
                    ((n.ph_ctype is s)
                     ((0.634457 -0.877781))
                     ((0.659792 -0.285263))))))
                 ((Syllable.syl_out < 2.9)
                  ((ph_vlng is a)
                   ((0.601663 0.0346774))
                   ((ph_vheight is 2)
                    ((0.55272 -0.0437895))
                    ((Syllable.last_accent < 2.4)
                     ((Syllable.accented is 0)
                      ((0.906332 0.0141081))
                      ((0.852122 0.607091)))
                     ((0.770102 0.31624)))))
                  ((Syllable.syl_out < 10.2)
                   ((ph_ctype is f)
                    ((p.ph_ctype is n)
                     ((0.389338 -0.325905))
                     ((Syllable.syl_out < 8.6)
                      ((p.ph_vlng is a)
                       ((0.799309 -0.674435))
                       ((Syllable.last_accent < 1.2)
                        ((n.ph_cplace is a)
                         ((0.920214 -0.40204))
                         ((1.0862 0.339684)))
                        ((0.741516 -0.26695))))
                      ((0.517774 -0.5127))))
                    ((p.ph_vlng is s)
                     ((Syllable.syl_out < 3.7)
                      ((0.443233 0.161368))
                      ((n.ph_ctype is s)
                       ((n.ph_cplace is a)
                        ((0.537607 -0.493967))
                        ((0.748256 0.163212)))
                       ((nn.ph_vc is +)
                        ((n.ph_ctype is f)
                         ((0.712609 0.6165))
                         ((0.923577 0.895174)))
                        ((0.647048 0.377632)))))
                     ((p.ph_cplace is v)
                      ((Syllable.ssyl_in < 2.1)
                       ((n.ph_ctype is s)
                        ((1.0453 0.400167))
                        ((0.680852 0.17245)))
                       ((0.633806 0.343591)))
                      ((p.ph_cplace is l)
                       ((Syllable.syl_in < 1.8)
                        ((0.628007 0.247364))
                        ((p.ph_cvox is -)
                         ((0.698121 0.127034))
                         ((Syllable.p.syl_break is 0)
                          ((0.912822 0.715828))
                          ((Syllable.ssyl_out < 2.5)
                           ((0.655237 -0.42045))
                           ((ph_vfront is 1)
                            ((0.618642 -0.4357))
                            ((1.27839 0.573625)))))))
                       ((p.ph_ctype is n)
                        ((ph_vlng is s)
                         ((0.414113 -0.263263))
                         ((n.ph_cvox is -)
                          ((0.525582 -0.421522))
                          ((1.21892 0.261966))))
                        ((Syllable.last_accent < 2.4)
                         ((Syllable.ssyl_in < 4.8)
                          ((p.ph_ctype is a)
                           ((Syllable.syl_in < 3.6)
                            ((0.741431 0.290947))
                            ((1.03176 0.604)))
                           ((Syllable.ssyl_out < 1.8)
                            ((n.ph_ctype is f)
                             ((0.812187 0.485182))
                             ((1.04135 0.0305)))
                            ((Syllable.next_accent < 2.1)
                             ((p.ph_vlng is d)
                              ((Syllable.n.syl_break is 0)
                               ((0.631712 -0.270227))
                               ((1.22029 0.190714)))
                              ((p.ph_cplace is g)
                               ((0.921835 -0.290821))
                               ((Syllable.asyl_in < 2.4)
                                ((p.ph_vheight is 2)
                                 ((Syllable.asyl_out < 2.2)
                                  ((1.10877 0.6998))
                                  ((0.79075 0.35275)))
                                 ((ph_ctype is n)
                                  ((1.0383 1.30676))
                                  ((p.ph_vc is +)
                                   ((0.932898 -0.100913))
                                   ((n.ph_cplace is l)
                                    ((0.969141 -0.0754571))
                                    ((n.ph_ctype is a)
                                     ((1.09014 0.550263))
                                     ((n.ph_cplace is v)
                                      ((1.07511 0.105306))
                                      ((n.ph_ctype is s)
                                       ((0.984622 0.126133))
                                       ((Syllable.n.syl_break is 0)
                                        ((pp.ph_vc is -)
                                         ((0.724887 -0.03515))
                                         ((1.08193 0.5717)))
                                        ((ph_vlng is a)
                                         ((0.909523 0.69715))
                                         ((n.ph_cvox is -)
                                          ((1.12862 0.16813))
                                          ((p.ph_cvox is -)
                                           ((1.20414 0.639095))
                                           ((2.86886 1.89037)))))))))))))
                                ((Syllable.syl_out < 6.5)
                                 ((n.ph_cvox is +)
                                  ((1.24944 0.696103))
                                  ((0.855774 0.0715263)))
                                 ((0.664269 0.138762))))))
                             ((n.ph_ctype is f)
                              ((0.864179 0.608818))
                              ((0.942906 -0.108793))))))
                          ((Syllable.syl_in < 8.6)
                           ((0.751579 -0.00695653))
                           ((n.ph_cplace is a)
                            ((0.771666 -0.320931))
                            ((1.04493 0.339267)))))
                         ((pos_in_syl < 1.2)
                          ((p.ph_cvox is -)
                           ((0.837142 -0.339739))
                           ((Syllable.syl_in < 7)
                            ((0.768723 0.21875))
                            ((1.14134 0.5426))))
                          ((0.63964 -0.387381)))))))))
                   ((Syllable.asyl_out < 4.6)
                    ((ph_cplace is a)
                     ((0.724653 -0.169955))
                     ((Syllable.next_accent < 0.3)
                      ((0.51718 -0.35215))
                      ((1.13596 0.176556))))
                    ((0.642069 -0.235962)))))))))
             ((pos_in_syl < 2.5)
              ((ph_ctype is s)
               ((Syllable.ssyl_in < 4.7)
                ((0.854321 1.37956))
                ((ph_cvox is -)
                 ((p.ph_vc is +)
                  ((1.38683 1.21247))
                  ((0.921708 0.345053)))
                 ((0.654393 0.64192))))
               ((ph_vfront is 3)
                ((Syllable.last_accent < 1.8)
                 ((0.985102 1.61714))
                 ((0.818766 2.05158)))
                ((Syllable.ssyl_in < 9)
                 ((p.ph_vlng is a)
                  ((ph_ctype is f)
                   ((0.90254 1.47777))
                   ((Syllable.syl_in < 12)
                    ((1.30459 1.13196))
                    ((0.792886 0.3833))))
                  ((n.ph_ctype is s)
                   ((ph_ctype is f)
                    ((0.426229 0.21405))
                    ((ph_vlng is s)
                     ((0.981103 1.76761))
                     ((1.27352 0.842842))))
                   ((ph_vlng is a)
                    ((Syllable.asyl_in < 3.4)
                     ((0.969393 2.9))
                     ((1.12539 2.54926)))
                    ((ph_ctype is l)
                     ((1.11074 1.85117))
                     ((ph_cplace is v)
                      ((1.20971 0.396368))
                      ((p.ph_vheight is 1)
                       ((Syllable.syl_in < 10.5)
                        ((1.06757 2.476))
                        ((0.987303 1.826)))
                       ((Syllable.stress is 0)
                        ((Syllable.syl_in < 13)
                         ((ph_cplace is a)
                          ((0.857211 1.99371))
                          ((p.ph_ctype is s)
                           ((0.926498 0.766158))
                           ((1.17959 1.00239))))
                         ((0.687654 1.003)))
                        ((ph_vfront is 1)
                         ((1.16137 2.9))
                         ((Syllable.asyl_in < 3.5)
                          ((1.43118 2.568))
                          ((1.16083 1.46446)))))))))))
                 ((Syllable.last_accent < 1.5)
                  ((1.08784 1.77216))
                  ((1.03564 1.15168))))))
              ((Syllable.syl_in < 13.4)
               ((ph_ctype is s)
                ((0.838732 1.26934))
                ((Syllable.syl_in < 8.2)
                 ((0.764419 1.94168))
                 ((Syllable.syl_in < 10.2)
                  ((1.32154 2.08568))
                  ((1.07774 1.53445)))))
               ((0.745267 0.994048)))))
            ((Syllable.last_accent < 2.7)
             ((Syllable.syl_out < 9.6)
              ((Syllable.ssyl_in < 0.8)
               ((0.756628 -0.42468))
               ((ph_vlng is a)
                ((0.820083 0.0950952))
                ((ph_vheight is 1)
                 ((0.878041 0.0813571))
                 ((n.ph_ctype is s)
                  ((Syllable.asyl_in < 2.5)
                   ((1.17498 -0.236033))
                   ((0.696229 -0.350667)))
                  ((ph_cvox is +)
                   ((Syllable.ssyl_in < 2.4)
                    ((0.865062 0.590727))
                    ((1.00859 1.19852)))
                   ((n.ph_ctype is f)
                    ((1.04216 -0.114667))
                    ((1.07208 0.365684))))))))
              ((0.73558 -0.197421)))
             ((0.673645 0.0166667)))))))))
      ((n.ph_ctype is l)
       ((Syllable.stress is 0)
        ((0.568367 -0.4451))
        ((nn.ph_vc is +)
         ((0.714381 -0.0305714))
         ((0.661015 -0.4715))))
       ((ph_vheight is 3)
        ((Syllable.syl_in < 1.8)
         ((0.561631 -0.717971))
         ((0.663875 0.0294762)))
        ((n.ph_vheight is 3)
         ((Syllable.syl_out < 13.1)
          ((0.80846 -0.0914444))
          ((0.709423 -0.48465)))
         ((p.ph_vlng is s)
          ((ph_ctype is f)
           ((0.543508 -0.380633))
           ((ph_ctype is n)
            ((0.516815 -0.132429))
            ((n.ph_cvox is -)
             ((0.798454 -0.630577))
             ((0.953205 0.24875)))))
          ((p.ph_cplace is v)
           ((0.752934 -0.305892))
           ((n.ph_cplace is l)
            ((pp.ph_vc is -)
             ((p.ph_cvox is +)
              ((0.432741 -0.776158))
              ((0.775683 -0.238227)))
             ((0.723188 0.0758095)))
            ((ph_vfront is 2)
             ((Syllable.stress is 0)
              ((pos_in_syl < 0.1)
               ((1.00386 0.536))
               ((0.501431 -0.339474)))
              ((0.467406 -0.1886)))
             ((n.ph_vfront is 1)
              ((0.766929 -0.281846))
              ((p.ph_ctype is n)
               ((0.866863 -0.336769))
               ((ph_cplace is l)
                ((0.886251 0.336923))
                ((Syllable.ssyl_out < 5.4)
                 ((Syllable.syl_in < 2)
                  ((0.742184 0.0369583))
                  ((0.745683 -0.602947)))
                 ((pp.ph_vc is 0)
                  ((0.92981 0.635692))
                  ((n.ph_vlng is s)
                   ((0.850583 -0.111091))
                   ((Syllable.ssyl_out < 8.5)
                    ((Syllable.asyl_out < 2.4)
                     ((1.02231 -0.0186))
                     ((Syllable.syl_break is 0)
                      ((pos_in_syl < 0.3)
                       ((0.841856 0.215))
                       ((0.698877 -0.494)))
                      ((Syllable.ssyl_in < 0.5)
                       ((1.13988 0.608263))
                       ((Syllable.syl_in < 2.2)
                        ((1.04147 -0.257222))
                        ((1.60204 0.479694))))))
                    ((0.913203 0.185696))))))))))))))))))))))
;; RMSE 0.784032 Correlation is 0.619165 Mean (abs) Error 0.602819 (0.501332)

))

(provide 'gswdurtreeZ)
