;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                       ;;
;;;                Centre for Speech Technology Research                  ;;
;;;                     University of Edinburgh, UK                       ;;
;;;                       Copyright (c) 1996,1997                         ;;
;;;                        All Rights Reserved.                           ;;
;;;                                                                       ;;
;;;  Permission to use, copy, modify, distribute this software and its    ;;
;;;  documentation for research, educational and individual use only, is  ;;
;;;  hereby granted without fee, subject to the following conditions:     ;;
;;;   1. The code must retain the above copyright notice, this list of    ;;
;;;      conditions and the following disclaimer.                         ;;
;;;   2. Any modifications must be clearly marked as such.                ;;
;;;   3. Original authors' names are not deleted.                         ;;
;;;  This software may not be used for commercial purposes without        ;;
;;;  specific prior written permission from the authors.                  ;;
;;;                                                                       ;;
;;;  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ;;
;;;  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ;;
;;;  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ;;
;;;  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ;;
;;;  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ;;
;;;  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ;;
;;;  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ;;
;;;  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ;;
;;;  THIS SOFTWARE.                                                       ;;
;;;                                                                       ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  
;;;  Handle module descriptions.
;;;  

(defvar *module-descriptions* nil
  "*module-descriptions*
   An association list recording the description objects for proclaimed
   modules.")

(define (module_description mod)
  "(module_description MOD)
   Returns the description record of the module named by symbol MOD"
  (let ((entry (assoc mod *module-descriptions*)))
    (if entry
	(car (cdr entry))
	nil
	)
    )
  )

(define (describe_module mod)
  "(describe_module MOD)
   Describe the module named by the symbol MOD."

  (let ((entry (module_description mod)))
    (format t "---------------------\n")
    (if entry
	(print_module_description entry)
	(format t "No description for %l\n" mod)
	)
    (format t "---------------------\n")
    )
  )

(define (describe_all_modules)
  "(describe_all_modules)
   Print descriptions of all proclaimed modules"
  (format t "---------------------\n")
  (let ((p *module-descriptions*))
    (while p
	   (print_module_description (car (cdr (car p))))
	   (format t "---------------------\n")
	   (set! p (cdr p))
	   )
    )
  )

(provide 'module_description)
