/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                       Copyright (c) 1996,1997                         */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*             Author :  Alan W Black                                    */
/*             Date   :  April 1996                                      */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/* Basic text utilities                                                  */
/*                                                                       */
/*=======================================================================*/
#include <stdio.h>
#include "festival.h"
#include "lexicon.h"
#include "text.h"

static void gc_token(void *t) { delete (EST_Token *)t; }

EST_Token *Token_LISP(LISP lt)
{
    EST_Token *t = new EST_Token;
    char *tmpstr;

    tmpstr = get_param_str("token",lt,"");
    t->set_token(tmpstr); wfree(tmpstr);
    tmpstr = get_param_str("whitespace",lt,"");
    t->set_whitespace(tmpstr); wfree(tmpstr);
    tmpstr = get_param_str("punctuation",lt,"");
    t->set_punctuation(tmpstr); wfree(tmpstr);
    tmpstr = get_param_str("prepunctuation",lt,"");
    t->set_prepunctuation(tmpstr); wfree(tmpstr);
    t->set_row(get_param_int("linenum",lt,0));
    t->set_col(get_param_int("linepos",lt,0));

    return t;
}

LISP lisp_Token(EST_Token &t)
{
    // return lisp representation of the token 
    LISP lt = NIL;

    if (t.col() != 0)
	lt = cons(make_param_int("linepos",t.col()),lt);
    if (t.row() != 0)
	lt = cons(make_param_int("linenum",t.row()),lt);
    if (t.whitespace() != "")
	lt = cons(make_param_str("whitespace",t.whitespace()),lt);
    if (t.prepunctuation() != "")
	lt = cons(make_param_str("prepunctuation",t.prepunctuation()),lt);
    if (t.string() != "")
	lt = cons(make_param_str("token",t.string()),lt);
    if (t.punctuation() != "")
	lt = cons(make_param_str("punctuation",t.punctuation()),lt);

    return lt;
}

EST_Stream_Item *add_token(EST_Utterance &u,LISP lt)
{
    // Add a token stream item to the end of EST_Token stream
    EST_Stream_Item item;
    EST_Token *tok = Token_LISP(lt);
    LISP f;

    item.init("Token");
    item.set_name(tok->string());
    if (tok->punctuation() == "")
	item.set_feature("punc","0");
    else
	item.set_feature("punc",tok->punctuation());
    for (f=lt; f != NIL; f=cdr(f))
    {
	char *name = get_c_string(car(car(f)));
	if (streq(name,"token") ||
	    streq(name,"whitespace") ||
	    streq(name,"punctuation"))
	    continue;   // these are dealt with above
	item.set_feature(name,get_c_string(car(cdr(car(f)))));
    }
    item.set_contents(tok,gc_token);
    u.stream("Token").append(item);
    return u.stream("Token").tail();
}

EST_Stream_Item *add_token(EST_Utterance &u,EST_Token &t)
{
    // Add a token stream item to the end of EST_Token stream
    EST_Stream_Item item;

    item.init("Token");
    item.set_name(t.string());
    if (t.punctuation() == "")
	item.set_feature("punc","0");
    else
	item.set_feature("punc",t.punctuation());
    item.set_feature("whitespace",t.whitespace());
    item.set_feature("prepunctuation",t.prepunctuation());
	
    u.stream("Token").append(item);
    return u.stream("Token").tail();
}
    
    


