 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)            */
 /*                   Date: Fri Apr 11 1997                              */
 /************************************************************************/
 /*                                                                      */
 /* The most simple frame synthesis -- just glue together raw          */
 /* waveforms. This is just a trivial test of the API.                   */
 /*                                                                      */
 /************************************************************************/

#include "festival.h"
#include "UnitDatabase.h"
#include "FramesUnit.h"

static void gc_wave(void *w) { delete (EST_Wave *)w; }

static inline int irint(float f)  { return (int)(f + 0.5); }
static inline int irint(double f) { return (int)(f + 0.5); }

LISP frames_signal_concatenation(LISP utt, LISP lunitstname, LISP lwavestname)
{
  const char *unit_stream_name = lunitstname?get_c_string(lunitstname):"Unit";
  const char *wave_stream_name = lwavestname?get_c_string(lwavestname):"Wave";

  EST_Wave *result;

  if (!TYPE(utt) == tc_utt)
    err("not an utterance", utt);

  EST_Utterance *u = GETUTTVAL(utt);

  if(!u->stream_present(unit_stream_name))
    err("no Unit stream", lunitstname);

  const FramesUnit::Chunk *chunks = FramesUnit::chunk_utterance(u, unit_stream_name, "Join");

  FramesUnit::dump_chunks(cout, chunks);

  int length=0;
  EST_Wave *wave = NULL;

  const FramesUnit::Chunk *ch;

  for(ch=chunks; ch->n != 0; ch++)
    for(int i=0; i < ch->n ; i++)
      {
	EST_Track *pms = ch->bit[i].unit->pitchmarks();
	if (!wave)
	  wave = ch->bit[i].unit->signal();

	for (int f = ch->bit[i].start_frame; f < ch->bit[i].end_frame; f++)
	  length += irint((pms->t(f+1) - pms->t(f)) * wave->sample_rate());
      }

  cout << " length = " << length << "\n";

  unsigned int pos=0;
  short *result_data = new short[length];

  for(ch=chunks; ch->n != 0; ch++)
    for(int i=0; i < ch->n ; i++)
      {
	EST_Track *pms = ch->bit[i].unit->pitchmarks();
	wave = ch->bit[i].unit->signal();
	int zerosam = irint(pms->t(0) * wave->sample_rate());

	for (int f = ch->bit[i].start_frame; f < ch->bit[i].end_frame; f++)
	  {
	    int startsam = irint(pms->t(f) * wave->sample_rate()) - zerosam;
	    int numsam   = irint(pms->t(f+1) * wave->sample_rate()) - zerosam - startsam;

	    memcpy(result_data+pos, 
		   wave->data()+startsam, 
		   numsam * sizeof(short));

	    // Paper over the join.

	    if (pos>0)
	      {
		short sval = result_data[pos-5];
		short eval = result_data[pos+5];
		for(int d=0; d<11 ; d++)
		  result_data[pos-5+d] = irint(sval + d*(eval-sval)/11.0);
	      }


	    pos += numsam;
	    cout << " pos = " << pos << "\n";
	  }
      }


  result = new EST_Wave;

  if (wave)
    result->set_data(result_data, 
		     length, 
		     wave->sample_rate(), 
		     1);

  if (u->stream_present(wave_stream_name))
    u->remove_stream(wave_stream_name);

  u->create_stream(wave_stream_name);
  
  EST_Stream *stream = &(u->stream(wave_stream_name));

  EST_Stream_Item item;

  item.init(wave_stream_name);
  item.set_name("[waveform]");
  item.set_contents(result,gc_wave);
  stream->append(item);

  return utt;
}

void frames_signal_concatenation_init(void)
{
  proclaim_module("frames_signal_concatenation");

  init_subr_3("frames_signal_concatenation", frames_signal_concatenation,
  "(frames_signal_concatenation UTT &opt UNIT_STREAM_NAME WAVE_STREAM_NAME)\n\
  Trivial synthesis by glueing the waveforms together.");
}
