/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                       Copyright (c) 1996,1997                         */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*             Author :  Steve Isard                                     */
/*             Date   :  1984                                            */
/*  This version was gifted by Steve for this new                        */
/*  copyright, the original retains their original copyright             */
/*                                                                       */
/*************************************************************************/
#include <math.h>
#include <stdio.h>
#include "t2s.h"

/* transform a set of reflection coefficients to linear prediction
 * coefficients using algorithm from HCL-H
 */

void rfctolpc(float *buf)
{
	float a,b;
	register float *cptr;
	register int n,k;

    /* HCL-H algorithm goes through coeffs in reverse of order in which they
     * appear here, working on buffer numbered from 1 upwards. To get same
     * effect, we make cptr point at space just after last coeff and let n and
     * k go down from -1 instead of up from 1.
     */
	cptr = buf + NCOEFFS; /* There should be NCOEFFS coeffs. Point just
                               * after last one.
                               */

	for(n = -1; n >= -NCOEFFS; n--) {
		*(cptr+n) = -(*(cptr+n));
		for(k = -1; 2*k >= n; k--) {
			a = *(cptr+k); 
			b = *(cptr+n-k);
			*(cptr+k) = a - b * *(cptr+n);
			*(cptr+n-k) = b - a * *(cptr+n);
		}
	}
}

