#!/bin/sh
###########################################################################
##                                                                       ##
##                Centre for Speech Technology Research                  ##
##                     University of Edinburgh, UK                       ##
##                         Copyright (c) 1997                            ##
##                        All Rights Reserved.                           ##
##                                                                       ##
##  Permission to use, copy, modify, distribute this software and its    ##
##  documentation for research, educational and individual use only, is  ##
##  hereby granted without fee, subject to the following conditions:     ##
##   1. The code must retain the above copyright notice, this list of    ##
##      conditions and the following disclaimer.                         ##
##   2. Any modifications must be clearly marked as such.                ##
##   3. Original authors' names are not deleted.                         ##
##  This software may not be used for commercial purposes without        ##
##  specific prior written permission from the authors.                  ##
##                                                                       ##
##  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ##
##  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ##
##  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ##
##  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ##
##  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ##
##  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ##
##  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ##
##  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ##
##  THIS SOFTWARE.                                                       ##
##                                                                       ##
###########################################################################
##
##  Basic test voices

FESTIVAL=$TOP/src/main/festival
HOME=$TOP/testsuite/data
export HOME

do_voices () {

	echo "multi-voices " >&2
	
	$FESTIVAL -b data/voices.scm || exit 1

        if cmp tmp/rab1.wav tmp/rab2.wav
		then echo rab voice: pass
		else echo rab voice: fail
	fi
        if cmp tmp/kd1.wav tmp/kd2.wav
		then echo kd voice: pass
		else echo kd voice: fail
	fi
        if cmp tmp/don1.wav tmp/don2.wav
		then echo don voice: pass
		else echo don voice: fail
	fi
}

echo >$OUTPUT

do_voices 2>&1 >> $OUTPUT

exit 0
