/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                    Author :  Simon King                               */
/*                    Date   :  January 1997                             */
/*-----------------------------------------------------------------------*/
/*             Acoustic model class for stack decoder                    */
/*                                                                       */
/*=======================================================================*/


#include "Acoustic_Model.h"

void *
Acoustic_Model::start_state()
{
    cerr << "Error : this is Acoustic_Model::start_state()" << endl;
    return NULL;
}

bool
Acoustic_Model::extend(void*, int)
{
    cerr << "Error : this is Acoustic_Model::extend" << endl;
    return false;
}



// =====================================================================


Track_Acoustic_Model::Track_Acoustic_Model(EST_Track &t)
{

    tfr = &t;

    // normalise, at the moment just ensure max element in each frame is 0
    // (equivalent to scaling probabilities to make max element = 1)
    // so that stack pruning will be admissible

    if(tfr->num_frames() <= 0)
	cerr << "Invalid Track as acoustic model : no frames !" << endl;

    if(tfr->num_channels() <= 0)
	cerr << "Invalid Track as acoustic model : no elements !" << endl;



    int frame,index;
    float max;
    for(frame=0;frame<tfr->num_frames();frame++){

	max=tfr->a(frame,0);
	for(index=1;index<tfr->num_channels();index++)
	    if(tfr->a(frame,index) > max)
		max=tfr->a(frame,index);
	
	for(index=0;index<tfr->num_channels();index++)
	    tfr->a(frame,index) -= max;
	
	
    }

    // added bonus : minimum distance to go from any frame to the
    // end is zero !!
    
}

void *
Track_Acoustic_Model::start_state()
{

    tam_state_t *ts;
    ts = new tam_state_t;
    ts->log_prob = 0.0;
    ts->frame = 0;

    return (void*)ts;
}

bool
Track_Acoustic_Model::extend(void* current_state, int current_word)
{

    tam_state_t *ts = (tam_state_t*)current_state;

    if(ts->frame >= tfr->num_frames()){ // is already finished

	// if current word doesn't require an observation, that is OK
	if( (current_word<0) && (current_word >= tfr->num_channels()) )
	    
	    return true;

	else
	    return false;

      
    
    // only account for (i.e. generate) an observation if index is in range
    }else if( (current_word>=0) && (current_word < tfr->num_channels()) ){
	

/*	cerr << "acoustic extend, frame=" << ts->frame
	     << " index=" << current_word
	     << " logprob=" << tfr->a(ts->frame,current_word)
	     << endl;
	     */
	ts->log_prob += tfr->a(ts->frame,current_word);
	ts->frame++;

    }
/*	
    }else{
	cerr << "acoustic extend, frame=" << ts->frame
	     << " index=" << current_word
	     << " no observation " 
	     << endl;
	
    }
    */
    return true;
    
}

int
Track_Acoustic_Model::get_frame(void* current_state)
{
    tam_state_t *ts = (tam_state_t*)current_state;
    return ts->frame;
}

float
Track_Acoustic_Model::get_log_prob(void* current_state)
{

    // remove this test later for speed
    if(current_state == NULL){
	cerr << "Track_Acoustic_Model::get_log_prob passed null state !" << endl;
	return 0.0;
    }

    tam_state_t *ts = (tam_state_t*)current_state;
    return ts->log_prob;
}

void
Track_Acoustic_Model::copy_state(void *from, void* &to)
{

    tam_state_t *ts,*ts2;

    ts = (tam_state_t*)from;
    ts2 = new tam_state_t;

    ts2->log_prob = ts->log_prob;
    ts2->frame = ts->frame;

    to = (void*)ts2;

}

void
Track_Acoustic_Model::delete_state(void *current_state)
{
    if(current_state != NULL)
	delete (tam_state_t*)current_state;
}


void
Track_Acoustic_Model::print_state(void *current_state)
{
    if(current_state == NULL){
	cerr << "NULL acoustic model state !";
	return;
    }

    tam_state_t *ts = (tam_state_t*)current_state;
    cerr << "AM(frame="
	 << ts->frame
	 << " logp=" 
	 << ts->log_prob;

    if(is_finished(current_state))
	cerr << " FINISHED";
    
    cerr << ")";
}


bool
Track_Acoustic_Model::is_finished(void *current_state)
{

    tam_state_t *ts = (tam_state_t*)current_state;

    // if frame counter is one past last observation
    // we have accounted for all observations

    return (bool)(ts->frame == tfr->num_frames());

}
