/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                    Author :  Simon King                               */
/*                    Date   :  January 1997                             */
/*-----------------------------------------------------------------------*/
/*                Decoder class for stack decoder                        */
/*                                                                       */
/*=======================================================================*/


#include "Decoder.h"
#include <string.h>
#include <stdlib.h>

Decoder::Decoder()
{
}

Decoder::Decoder(Hypothesis *initial_hypothesis_ptr,
		 Acoustic_Model &amodel,
		 Language_Model &lmodel,
		 int m)
{
    (void)initial_hypothesis_ptr;
    (void)amodel;
    (void)lmodel;
    make_heap(m);
}


Decoder::~Decoder()
{
    delete heap;
}


void
Decoder::make_heap(int)
{
    cerr << "Error : this is Decoder::make_heap" << endl;
    heap = NULL;
}


bool
Decoder::decode(int n)
{
    (void)n;
    Hypothesis *current_hypothesis_ptr;
    EST_TList<Hypothesis*> new_hypotheses;
    EST_TList<Hypothesis*> finished_hypotheses;
    EST_TBI *h_ptr;
    Heap::insert_error_t e;
    
    // to do : can compute a reasonable initial global min
    // from acoustic and language models
    float global_min_log_prob = -1000; // hack value


    // to do :
    // global min does not apply when time normalising scores

    // **********************************
    // "scores can go up as well as down"
    // **********************************



    // sanity check
    if( heap->size() == 0 ){
	cerr << "Oops, heap empty at start of decode !" << endl;
	return false;
    }
    
    
    while( heap->size() > 0 ){

	
	// repeatedly pop hypotheses from the stack 
	// until we get an unfinished one
	// saving the finished ones as we go
	while( ((current_hypothesis_ptr=(Hypothesis*)heap->extract_max()) != NULL)
	       && ( is_finished(current_hypothesis_ptr) ) ){
	    
	    // currently only implemented 1-best search
	    cerr << endl << "winning hypothesis : " << endl;
	    print(current_hypothesis_ptr);

	    // for N best we need to relax global_min_score pruning
	    // (to be an envelope - in fact part of the LUB-SF !)

	    cerr << endl;
	    return true;
	    
	}
	
		
	if(current_hypothesis_ptr == NULL){
	    recover();
	    
	}else{ // away we go ...
	    
	    //cerr << "===============================" << endl;
	    cerr << "Popped: ";
#ifdef DEBUG
	    print(current_hypothesis_ptr);
#else
	    cerr << current_hypothesis_ptr->h_length << "   \r";
#endif

#ifdef DEBUG
	    cerr << "Global min log prob is " << global_min_log_prob << endl;
#endif

	    if( language_model->is_finished(current_hypothesis_ptr->language_model_state) ){

		// but acoustic model not finished

		//cerr << "FAILED : ";
		//print(current_hypothesis_ptr);
		delete_hypothesis(current_hypothesis_ptr);

	   }else{ // it's not complete - the usual case
		
		// from current hypothesis make several new ones 
		// according to the grammar
		new_hypotheses.clear();
		new_hypotheses = 
		    generate_new_hypotheses(current_hypothesis_ptr);
		
		// we've finished with this now
		delete_hypothesis(current_hypothesis_ptr);
		
#ifdef DEBUG
		cerr << "----- from language model ------" << endl;
		for(h_ptr=new_hypotheses.head();h_ptr!=NULL;h_ptr=next(h_ptr)){
		    print(new_hypotheses(h_ptr));
		}
		cerr << "--------------------------------" << endl;


		cerr << "----- from acoustic model ------" << endl;
#endif		
		
		// extend each new hypothesis using acoustic observations
		for(h_ptr=new_hypotheses.head();h_ptr!=NULL;h_ptr=next(h_ptr)){

		    // first check log_prob to see if it's worth bothering
		    set_log_prob(new_hypotheses(h_ptr));
		    if(new_hypotheses(h_ptr)->h_partial_log_prob +
		       new_hypotheses(h_ptr)->h_estimated_remaining_log_prob
		       < global_min_log_prob){
			
#ifdef DEBUG
			cerr << "Killed: ";
			print(new_hypotheses(h_ptr));
#endif
			delete_hypothesis(new_hypotheses(h_ptr));
			new_hypotheses(h_ptr) = NULL;
			
		    

		    // if not already finished, try to extend acoustic model
		    }else if(!is_finished(new_hypotheses(h_ptr)) &&
			     !extend(new_hypotheses(h_ptr)) ){

			// extend failed - discard this hypothesis
#ifdef DEBUG
			cerr << "Killed: ";
			print(new_hypotheses(h_ptr));
#endif
			delete_hypothesis(new_hypotheses(h_ptr));
			new_hypotheses(h_ptr) = NULL;
			



		    }else{
			// put it on the heap
			
			set_log_prob(new_hypotheses(h_ptr));
			if(new_hypotheses(h_ptr)->h_partial_log_prob +
			   new_hypotheses(h_ptr)->h_estimated_remaining_log_prob
			   < global_min_log_prob){
			    
#ifdef DEBUG
			    cerr << "Killed: ";
			    print(new_hypotheses(h_ptr));
#endif
			    delete_hypothesis(new_hypotheses(h_ptr));
			    new_hypotheses(h_ptr) = NULL;

			
			}else if(lm_is_finished(new_hypotheses(h_ptr))){
			    
			    // language model is finished
			    
			    if(am_is_finished(new_hypotheses(h_ptr))){
				
				// both finished

				// update global min log prob
				if(new_hypotheses(h_ptr)->h_partial_log_prob +
				   new_hypotheses(h_ptr)->h_estimated_remaining_log_prob
				   > global_min_log_prob)

				    global_min_log_prob = 
					new_hypotheses(h_ptr)->h_partial_log_prob +
					new_hypotheses(h_ptr)->h_estimated_remaining_log_prob;
				    
#ifdef DEBUG
				cerr << endl << endl << endl;
				cerr << "updated global min log prob to "
				     << global_min_log_prob << endl;
				cerr << endl << endl << endl;
#endif
				// mark as finished by setting length to 1 past last frame
				new_hypotheses(h_ptr)->h_length++;

				set_log_prob(new_hypotheses(h_ptr));
				set_eval_fn(new_hypotheses(h_ptr));
				e=heap->insert(new_hypotheses(h_ptr));
				switch(e){
				case Heap::inserted_ok:
#ifdef DEBUG
				    cerr << "Pushed: ";
				    print(new_hypotheses(h_ptr));
#endif
				    break;
				    
				case Heap::heap_full:
				    cerr << "Decoder::_decode : Heap filled up !" << endl;
				    delete_hypothesis(new_hypotheses(h_ptr));
				    return false;
				    break;

				case Heap::prune_item:
#ifdef DEBUG
				    cerr << "Pruned: ";
				    print(new_hypotheses(h_ptr));
#endif
				    delete_hypothesis(new_hypotheses(h_ptr));
				    new_hypotheses(h_ptr) = NULL;
				    break;

				}

				// this hypothesis belongs to the heap now, 
				// so for safety forget the pointer to it
				new_hypotheses(h_ptr) = NULL;

				
			    }else{

				// language model is finished
				// but acoustic model not finished even after extend(...)
#ifdef DEBUG
				cerr << "Failed: ";
				print(new_hypotheses(h_ptr));
#endif
				delete_hypothesis(new_hypotheses(h_ptr));
				new_hypotheses(h_ptr) = NULL;
				
				
			    }
			    



			    
			}else{
			    
			    // neither model has finished
			    
			    set_log_prob(new_hypotheses(h_ptr));
			    set_eval_fn(new_hypotheses(h_ptr));
			    e=heap->insert(new_hypotheses(h_ptr));
			    switch(e){
			    case Heap::inserted_ok:
#ifdef DEBUG
				cerr << "Pushed: ";
				print(new_hypotheses(h_ptr));
#endif
				break;
				
			    case Heap::heap_full:
				cerr << "Decoder::decode : Heap filled up !" << endl;
				delete_hypothesis(new_hypotheses(h_ptr));
				return false;
				break;
				
			    case Heap::prune_item:
#ifdef DEBUG
				cerr << "Pruned: ";
				print(new_hypotheses(h_ptr));
#endif
				delete_hypothesis(new_hypotheses(h_ptr));
				break;
				
			    }
			    
			    // this hypothesis belongs to the heap now, 
			    // so for safety forget the pointer to it
			    new_hypotheses(h_ptr) = NULL;
		    
			}
		        
		    } // matches if...else
		   
		} // loop to extend each hypothesis

#ifdef DEBUG
		cerr << "--------------------------------" << endl;
#endif

	   } // matches : else
	    

	}

	// housekeeping
	control_heap();

	
    } // matches while(...)
    
    // should never reach this point !
    
    // oh dear, heap emptied
    cerr << "Heap emptied unexpectedly !" << endl;
    return false;
    
    }



void
Decoder::recover(){

	cerr << "Decoder::recover() : Something went wrong ! (heap emptied ?)" << endl;
	// DO SOMETHING WITH THE HYPOTHESES ! ......
	
}



EST_TList<Hypothesis*> 
Decoder::generate_new_hypotheses(Hypothesis *current_hypothesis_ptr)
{
    (void)current_hypothesis_ptr;
    cerr << "Error : this is Decoder::generate_new_hypotheses" << endl;
    return EST_TList<Hypothesis*>();
}


bool
Decoder::extend(Hypothesis*h)
{
    (void)h;
    cerr << "Error : this is Decoder::extend" << endl;
    return true;    
}


void
Decoder::set_eval_fn(Hypothesis* h)
{
    (void)h;
    cerr << "Error : this is Decoder::set_eval_fn" << endl;
}


void 
Decoder::set_log_prob(Hypothesis* h)
{
    set_partial_log_prob(h);
    set_estimated_remaining_log_prob(h);
}


void 
Decoder::set_partial_log_prob(Hypothesis*)
{
    cerr << "Error : this is Decoder::set_partial_log_prob" << endl;
}


void 
Decoder::set_estimated_remaining_log_prob(Hypothesis*)
{
    cerr << "Error : this is Decoder::set_estimated_remaining_log_prob" << endl;
}




bool
Decoder::is_finished(Hypothesis*)
{
    cerr << "Error : this is Decoder::is_finished" << endl;
    return false;
}

bool
Decoder::lm_is_finished(Hypothesis*)
{
    cerr << "Error : this is Decoder::sm_is_finished" << endl;
    return false;
}

bool
Decoder::am_is_finished(Hypothesis* h)
{
    (void)h;
    cerr << "Error : this is Decoder::am_is_finished" << endl;
    return false;
}

void
Decoder::print(Hypothesis *h)
{
    (void)h;
    cerr << "Error : this is Decoder::print(Hypothesis*)" << endl;
}


void 
Decoder::delete_hypothesis(Hypothesis *hypothesis_ptr)
{
    (void)hypothesis_ptr;
    cerr << "Error : this is Decoder::delete(Hypothesis*)" << endl;
}

void 
Decoder::control_heap()
{

}
