/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                    Author :  Simon King                               */
/*                    Date   :  January 1997                             */
/*-----------------------------------------------------------------------*/
/*             Acoustic model class for stack decoder                    */
/*                                                                       */
/*=======================================================================*/


#ifndef __ACOUSTIC_MODEL_H__
#define __ACOUSTIC_MODEL_H__

#include "EST.h"

class Acoustic_Model {
private:
protected:
public:
    virtual void *start_state();
    virtual bool extend(void* current_state, int current_word);

};

class Track_Acoustic_Model : public Acoustic_Model {

private:
    
protected:

    EST_Track *tfr;

    struct tam_state_t{
	int frame;
	float log_prob;
    };
    

    // for A* search : a bound on the least possible distance to the end
    // currently normalise TFR so max log prob in every frame is 0
    // so min_distance_to_go is 0 from any frame to the end of the utterance !

    //FVector min_distance_to_go;

public:

    Track_Acoustic_Model(EST_Track &t);

    void *start_state();
    bool extend(void* current_state, int current_word);

    float get_log_prob(void *current_state);
    bool is_finished(void *current_state);
    int get_frame(void *current_state);

    void copy_state(void *from, void* &to);
    void delete_state(void *current_state);
    void print_state(void *current_state);

};



#endif

