 /*************************************************************************/
 /*                                                                       */
 /*                Centre for Speech Technology Research                  */
 /*                     University of Edinburgh, UK                       */
 /*                      Copyright (c) 1995,1996                          */
 /*                        All Rights Reserved.                           */
 /*  Permission to use, copy, modify, distribute this software and its    */
 /*  documentation for research, educational and individual use only, is  */
 /*  hereby granted without fee, subject to the following conditions:     */
 /*   1. The code must retain the above copyright notice, this list of    */
 /*      conditions and the following disclaimer.                         */
 /*   2. Any modifications must be clearly marked as such.                */
 /*   3. Original authors' names are not deleted.                         */
 /*  This software may not be used for commercial purposes without        */
 /*  specific prior written permission from the authors.                  */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
 /*  THIS SOFTWARE.                                                       */
 /*                                                                       */
 /*************************************************************************/
 /*                                                                       */
 /*                      Author :  Paul Taylor                            */
 /*                      Date   :  April 1995                             */
 /* --------------------------------------------------------------------- */
 /*                       Template List Class                             */
 /*                                                                       */
 /* Modified by RJC, 21/7/97. Now much of the working code is in the      */
 /* UList class, this template class provides a type safe front end to    */
 /* the untyped list.                                                     */
 /*                                                                       */
 /*************************************************************************/



#include "EST_TList.h"

template<class T> EST_TList<T>::EST_TList(EST_TList<T> &l)
{
    init();
    EST_TBI *p;
    for (p = l.head();  p; p = next(p))
	append(l.item(p));
}

template<class T> void EST_TList<T>::exchange_contents(EST_TBI *a,EST_TBI *b)
{

    if(a==b)
	return;

    T temp;

    temp = ((EST_TItem<T> *)a)->val;
    ((EST_TItem<T> *)a)->val = ((EST_TItem<T> *)b)->val;
    ((EST_TItem<T> *)b)->val = temp;

}


template<class T> EST_TList<T> &EST_TList<T>::operator=(const EST_TList<T> &a) 
{
    EST_TBI *p;
    clear();			// clear out all current items in list.
    
    for (p = a.head(); p != 0; p = next(p))
	append(a.item_C(p));
    
    return *this;
}


template<class T> EST_TList<T> &EST_TList<T>::operator+=(const EST_TList<T> &a)
{
    EST_TBI *p;
    if (this == &a)
      {
	cerr << "Error: tried to add list to itself\n";
	return *this;
      }
    
    for (p = a.head(); p != 0; p = next(p))
	append(a.item_C(p));
    
    return *this;
}

template<class T> bool
EST_TList<T>::operator >(const EST_TList<T> &a)
{
    (void)a;
    cerr << "inline bool operator >(const EST_TList<T> &a) NOT IMPLEMENTED !" 
	 << endl;
    return false;
}



