/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                      Author :  Paul Taylor                            */
/*                      Date   :  April 1995                             */
/*-----------------------------------------------------------------------*/
/*                      Template EST_TMatrix Class                       */
/*                                                                       */
/*=======================================================================*/

#include "EST_TMatrix.h"
#include "EST_TVector.h"
#include "fstream.h"
#include "iostream.h"
#include "EST_cutils.h"


template<class T> EST_TMatrix<T>::EST_TMatrix()
{
    N = M = 0;
    x = 0;
}

template<class T> EST_TMatrix<T>::~EST_TMatrix()
{
    int i;

    if (x != 0)
    {
	for (i = 0; i < M; ++i)
	    delete [] x[i];
	delete [] x;
    }
    N = M = 0;
}

template<class T> EST_TMatrix<T>::EST_TMatrix(int m, int n)
{
    x = 0;
    N = M = 0;
    resize(m, n);
}

template<class T> void EST_TMatrix<T>::copy(const EST_TMatrix<T> &a)
{
    int i, j;
    resize(a.num_rows(), a.num_columns());

    for (i = 0; i < M; ++i)
	for (j = 0; j < N; ++j)
	    x[i][j] = a.el(i, j);
}

template<class T> EST_TMatrix<T>::EST_TMatrix(const EST_TMatrix<T> &in)
{
    x = 0;
    N = M = 0;
    copy(in);
}

template<class T> void EST_TMatrix<T>::resize(int newm, int newn)
{
    T **newx;
    int i, j;

    newx = new T*[newm];
    for (i = 0; i < newm; ++i)
	newx[i] = new T[newn];

    i = 0;
    j = 0;
    int i2, j2;

    if (x != 0) // check to make sure the array has been malloced
    {
	for (; i < Lof(M, newm); ++i)
	    for (j = 0; j < Lof(N, newn); ++j)
		newx[i][j] = x[i][j];
    }

    for (i2 = i; i2 < newm; ++i2)
	for (j2 = 0; j2 < newn; ++j2)
	    newx[i2][j2] = def_val;

    for (i2 = 0; i2 < newm; ++i2)
	for (j2 = j; j2 < newn; ++j2)
	    newx[i2][j2] = def_val;

    if (x != 0)
    {
	for (i=0; i < M; i++)
	    delete [] x[i];
	delete [] x;
    }
    
    M = newm;
    N = newn;
    x = newx;
}

template<class T> EST_write_status EST_TMatrix<T>::save(const EST_String file)
{
    int i, j;
    ostream *outf;
    if (file == "-")
	outf = &cout;
    else
	outf = new ofstream(file);
    
    for (i = 0; i < num_rows(); ++i)
    {
	for (j = 0; j < num_columns(); ++j)
	    *outf << x[i][j] << " ";
	*outf << endl;
    }
    
    if (outf != &cout)
	delete outf;

    return write_ok;
}

template<class T> EST_read_status
           EST_TMatrix<T>::load(const EST_String filename)
{
    // this function can only be written if we can find a way of parsing
    // an unknown type;
    (void) filename;
    cerr << "Matrix loading not implemented yet\n";
    return misc_read_error;

}

template<class T> EST_TMatrix<T> &EST_TMatrix<T>::operator=(const EST_TMatrix<T> &in)
{
    copy(in);
    return *this;
}

template<class T> T &EST_TMatrix<T>::operator()(int m, int n)
{
    if (m >= M)
    {
	cerr << "Tried to access row " << m << " of " << M << " row matrix\n";
	abort();
	m = 0;
    }
    if (n >= N)
    {
	cerr << "Tried to access column " << n<<" of "<<N<<" column matrix\n";
	n = 0;
    }
    
    return x[m][n];
}

template<class T> const T &EST_TMatrix<T>::el(int m, int n) const
{
    if (m >= M)
    {
	cerr << "Tried to access row " << m << " of " << M << " row matrix\n";
	abort();
	m = 0;
    }
    if (n >= N)
    {
	cerr << "Tried to access column " << n<<" of "<<N<<" column matrix\n";
	n = 0;
    }
    
    return x[m][n];
}

