/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                   Author :  Paul Taylor                               */
/*                   Date   :  January 1995                              */
/*-----------------------------------------------------------------------*/
/*              Key/Value list template class                            */
/*                                                                       */
/*=======================================================================*/
#ifndef __EST_KV_H__
#define __EST_KV_H__

#include <math.h>
#include "EST_TList.h"
#include "EST_String.h"

template<class K, class V> class KVI {
 public:
    K k;
    V v;

    inline bool operator==(const KVI<K,V> &i){
	return( (i.k == k) && (i.v == v) );
    }

    friend  ostream& operator << (ostream& s, const KVI<K,V> &i);
};

template<class K, class V> class KVL {
 public:
    KVL() {;}			// default constructor
    KVL(KVL<K, V> &kv); 	// copy constructor
    
    EST_TList< KVI<K,V> > list;	// linked list of key-val pairs. Don't use
    // this as it will be made private in the future
    
    const int length() const {return list.length();} // length of list;

    EST_Litem * head() const {return list.head();};

    void clear();

    const V &val(const K &rkey, int m=0) const;// return value according to key
    const V &valp(EST_Litem *ptr, int m=0) const;     // return value according to ptr
    const V &val_def(const K &rkey,const V &def) const;  // value or default 
    const K &key(EST_Litem *ptr, int m=1) const;	// find key, reference by ptr 
    
    const int present(const K &rkey) const;   // is key present?  

    void map(void (*func)(K&, V&));		// apply function to each pair
    
    // add key-val pair to list
    int add_item(const K rkey,const V rval, int no_search = 0);

    int change_item(const K &rkey,const V &rval); // change key-val pair.
    int change_item(EST_TBI *ptr,const V &rval); // change key-val pair.
    int change_key(EST_TBI *ptr,const K &rkey); // change name of key pair.
    
    friend ostream& operator << (ostream& s, const KVL<K,V> &kv);
    
    KVL<K, V> & operator =  (const KVL<K,V> &kv); // full copy of KV list.
    KVL<K, V> & operator += (const KVL<K,V> &kv); // add kv after existing list.
    KVL<K, V>   operator +  (const KVL<K,V> &kv); // make new concatenated list
};

// common use of template is for int, int combinations, hence the typedefs.

#endif				// __KVL_H__
