 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                        Copyright (c) 1997                            */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute and sell this software  */
 /*  and its documentation for any purpose is  hereby granted without    */
 /*  fee, subject to the following conditions:                           */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)            */
 /*                 Date  : February 1997                                */
 /*----------------------------------------------------------------------*/
 /*                                                                      */
 /* A Regular expression class to go with the CSTR EST_String class.         */
 /*                                                                      */
 /************************************************************************/

#ifndef __EST_REGEX_H__
#define __EST_REGEX_H__

class EST_Regex;

#include "EST_String.h"

class EST_Regex {
private:
  EST_String expression;
  void *compiled;	   // Evil but means we dont have to include regexp.h
  void *compiled_match;

  void compile();
  void compile_match();
  char *regularize(int match) const;
public:
  EST_Regex(EST_String s);

  EST_Regex(const char *ex);

  EST_Regex(EST_Regex &ex);

  ~EST_Regex();

  int  size() const { return expression.size; };
  int  run(const char *on, int from, int &start, int &end, int *starts=NULL, int *ends=NULL);
  int  run_match(const char *on, int from=0, int *starts=NULL, int *ends=NULL);

  EST_String tostring(void) const {return expression;};

  EST_Regex &operator = (const EST_Regex ex);
  EST_Regex &operator = (const EST_String s);
  EST_Regex &operator = (const char *s);

  friend ostream &operator << (ostream &s, const EST_Regex &str);
};

ostream &operator << (ostream &s, const EST_Regex &str);

extern EST_Regex RXwhite;		// "[ \n\t]+"
extern EST_Regex RXalpha;		// "[A-Za-z]+"
extern EST_Regex RXlowercase;	// "[a-z]+"
extern EST_Regex RXuppercase;	// "[A-Z]+"
extern EST_Regex RXalphanum;	// "[0-9A-Za-z]+"
extern EST_Regex RXidentifier;	// "[A-Za-z_][0-9A-Za-z_]+"
extern EST_Regex RXint;		// "-?[0-9]+"
extern EST_Regex RXdouble;		// "-?\\(\\([0-9]+\\.[0-9]*\\)\\|\\([0-9]+\\)\\|\\(\\.[0-9]+\\)\\)\\([eE][---+]?[0-9]+\\)?"

// GCC lets us use the static constant to declare arrays, Sun CC
// doesn`t, so for a quiet, if ugly, life we declare it here with a suitable
// value and check in EST_Regex.C to make sure it`s OK

#define  EST_Regex_max_subexpressions 10

#endif	
