 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/
 /*                                                                       */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             */
 /*                   Date: Tue Aug 26 1997                               */
 /* --------------------------------------------------------------------  */
 /* Extending buffers, i.e. arrays which grow as needed. I got fed up     */
 /* of writing this code all over the place.                              */
 /*                                                                       */
 /*************************************************************************/


#ifndef __EST_TBUFFER_H__
#define __EST_TBUFFER_H__

#include "EST_bool.h"

#define TBUFFER_N_OLD (3)
#define TBUFFER_DEFAULT_SIZE 0
#define TBUFFER_DEFAULT_STEP 100

struct old_tbuffer { void *mem; unsigned int size; };

extern struct old_tbuffer EST_old_buffers[TBUFFER_N_OLD];

template<class T>
class EST_TBuffer {

private:
  unsigned int p_size;
  int p_step;			// if negative it is a percentage
  T * p_buffer;

private:
  void init(unsigned int size, int step);
  void expand_to(unsigned int req_size, bool cpy);
  void expand_to(unsigned int req_size, const T &set_to, int howmany=-1);
  
public:
  EST_TBuffer(unsigned int size=TBUFFER_DEFAULT_SIZE, 
	      int step=TBUFFER_DEFAULT_STEP);

  ~EST_TBuffer(void);

  unsigned int length(void) const { return p_size; };

  void set(const T &set_to, int howmany=-1);

  void ensure(unsigned int req_size, bool cpy)	// make sure there is enough space
    {if (req_size > p_size) expand_to(req_size, cpy);}	

  void ensure(unsigned int req_size, const T &set_to, int howmany=-1)	// make sure there is enough space
    {if (req_size > p_size) expand_to(req_size, set_to, howmany);}	

  void ensure(unsigned int req_size)	// make sure there is enough space
    {if (req_size > p_size) expand_to(req_size, (bool)TRUE);}	

  T *b(void) const {return p_buffer;};

  operator T * (void) const { return p_buffer; };
};

#endif
