/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                     Copyright (c) 1994,1995,1996                      */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                    Author :  Paul Taylor and Alan W Black             */
/*                    Date   :  July 1996                                */
/*-----------------------------------------------------------------------*/
/*              Various C utility functions                              */
/*                                                                       */
/*=======================================================================*/
#ifndef __EST_CUTILS_H__
#define __EST_CUTILS_H__

#include "EST_common.h"

#ifdef __cplusplus
extern "C" {
#endif

extern char *est_tools_version;

#include "EST_walloc.h"
#include "EST_system.h"

#ifndef streq
#define streq(X,Y) (strcmp(X,Y)==0)
#endif

char *cmake_tmp_filename();

long_long watoll(const char *str);

/* NOTE perqs (from Three Rivers) have the third byte order) are not  */
/* supported, if you find a  working one let me know and I'll add     */
/* support -- awb                */
enum EST_bo_t {bo_big, bo_little, bo_perq};

extern int est_endian_loc;
/* Sun, HP, SGI Mips, M68000 */
#define EST_BIG_ENDIAN (((char *)&est_endian_loc)[0] == 0)
/* Intel, Alpha, DEC Mips, Vax */
#define EST_LITTLE_ENDIAN (((char *)&est_endian_loc)[0] != 0)
#define EST_NATIVE_BO (EST_BIG_ENDIAN ? bo_big : bo_little)

#define SWAPINT(x) ((((unsigned)x) & 0xff) << 24 | \
                    (((unsigned)x) & 0xff00) << 8 | \
		    (((unsigned)x) & 0xff0000) >> 8 | \
                    (((unsigned)x) & 0xff000000) >> 24)
#define SWAPSHORT(x) ((((unsigned)x) & 0xff) << 8 | \
                      (((unsigned)x) & 0xff00) >> 8)
void swapdouble(double *d);
void swapfloat(float *f);

void swap_bytes_ushort(unsigned short *data, int length);
void swap_bytes_short(short *data, int length);
void swap_bytes_float(float *data, int length);
void swap_bytes_double(double *data, int length);

enum EST_bo_t str_to_bo(const char *boname);
const char *bo_to_str(enum EST_bo_t bo);

/* return the greater of the two values */
#define Gof(a, b) (((a) > (b)) ? (a) : (b))
/* return the lesser of the two values  */
#define Lof(a, b) (((a) < (b)) ? (a) : (b))


#ifdef __cplusplus
}
#endif


#endif /*__EST_CUTILS_H__ */
