/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                         Copyright (c) 1996                            */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, and modify this software and its            */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                    Author :  Paul Taylor                              */
/*                    Date   :  February 1996                            */
/*-----------------------------------------------------------------------*/
/*              Intonational Event Include file                          */
/*                                                                       */
/*=======================================================================*/




#ifndef __RFC_H__
#define __RFC_H__

#include "EST.h"
#include "EST_Event.h"


#define RFCS(cell) ((EventSI*)((cell).contents()))
#define RFCC(cell) ((EventRFC*)((cell).l()))
#define TiltC(cell) ((EventTilt*)((cell).contents()))


EST_Stream rfc_label(EST_Track &fz, EST_Stream &event_list, EST_Option &op);
int pos_event(EST_Stream_Item &evi);
int sil_event(EST_Stream_Item &evi);
int con_event(EST_Stream_Item &evi);
void print_tune(EST_Stream &tune);
EST_Stream phrase_tune(EST_Stream &ev_list);
EST_Stream tune_values(EST_Stream &ev_list);
void strip_silence(EST_Stream &ev_list);
EST_Stream_Item zero_tilt();
int read_ev_fields(EST_Stream &ev);
EST_String guess_ev_format(EST_Stream &ev);
int read_tilt_fields(EST_Stream &ev);
int read_rfc_fields(EST_Stream &ev);
void write_rfc_fields(EST_Stream &ev, EST_String format);
void write_tilt_fields(EST_Stream &ev);
void write_tilt2_fields(EST_Stream &ev);
void print_tilt_events(EST_Stream &ev);
void print_rfc2_events(EST_Stream &ev);
void print_rfc_events(EST_Stream &ev);
float fncurve(float length, float t, float curve);
float distance(EST_Track &fz, int pos, EST_Track &new_fz, int
	       num_points);
float weight(float duration);
float unit_curve(EST_String type, float amp, float dur, float t);


EST_Track rfc_to_track(EST_Stream &ev_list, float f_shift, int no_conn);

int fill_values(EST_Track &fz, int &j, float amp, float dur, float
		start_f0, float start_pos, float f_shift, EST_String type);
EST_Stream tilt_to_rfc(EST_Stream &ev_tilt);
EST_Stream rfc_to_tilt(EST_Stream &ev_rfc);

int validate_rfc_stream(EST_Stream &ev);


#endif /* RFC */
