/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                         Copyright (c) 1994,1995,1996                  */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                    Author :  Paul Taylor                              */
/*                    Date   :  May 1994                                 */
/*                    Release:  0.9                                      */
/*-----------------------------------------------------------------------*/
/*              Auxiliary Label Routines header file                     */
/*                                                                       */
/*=======================================================================*/

#ifndef __EST_STREAM_AUX_H__
#define __EST_STREAM_AUX_H__

#include "EST_String.h"
#include "EST_Track.h"
#include "EST_Utterance.h"
#include "EST_Option.h"

void convert_to_broad(EST_Stream &seg, EST_StrList &pos_list, 
		      EST_String broad_name ="");
void convert_to_broad_class(EST_Stream &seg, const EST_String &class_type, 
			   EST_Option &options);



int merge_label(EST_Stream &seg, const EST_String &labtype);

void change_label(EST_Stream &seg, const EST_String &oname, const EST_String &nname);

void merge_all_label(EST_Stream &seg, const EST_String &labtype);

void track_to_label(EST_Track tr, EST_Stream &lab, float thresh=0.0);


EST_Track label_to_track(EST_Stream &lab, EST_Option &al, EST_Option &op);
EST_Track label_to_track(EST_Stream &lab, float shift, float offset=0.0, float range = 1.0, float req_length = -1.0, EST_String pad="low");

void shift_label(EST_Stream &seg, float shift);
void label_map(EST_Stream &seg, EST_Option &map);
void print_stream_features(EST_Stream &s);
void quantize(EST_Stream &a, float q);
int edit_labels(EST_Stream &a, EST_String sedfile);

void StreamList_select(EST_StreamList &mlf, EST_StrList filenames, bool
			exact_match);
EST_Stream StreamList_extract(EST_StreamList &mlf, EST_String filename, bool base);
EST_Stream StreamList_combine(EST_StreamList &mlf);

int stream_divide(EST_StreamList &mlf, EST_Stream &lab, EST_Stream &keylab,
		   EST_String ext);
EST_TBI *StreamList_ptr_extract(EST_StreamList &mlf, EST_String filename, bool base);

void stream_convert(EST_Stream &lab, EST_Option &al, EST_Option &op);

EST_read_status load_StreamList(EST_String filename, EST_StreamList &plist);
EST_write_status save_StreamList(EST_String filename, EST_StreamList &plist);
EST_write_status save_StreamList(EST_String filename, EST_StreamList &plist, int time=1, int path = 1);

EST_read_status read_StreamList(EST_StreamList &mlf, EST_StrList &files, EST_Option &al);

int find_filename(EST_StrList &f, EST_String &filename);

#endif /* __EST_STREAM_AUX_H__ */
