/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                         Copyright (c) 1996                            */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, and modify this software and its            */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                 Author :  Paul Taylor                                 */
/*                 Date   :  February 1996                               */
/*-----------------------------------------------------------------------*/
/*                       Event RFC labelling                             */
/*                                                                       */
/*=======================================================================*/

#include "EST_String.h"
#include "EST.h"
#include "EST_Event.h"
#include "EST_rfc.h"
#include "math.h"

float unit_curve(EST_String type, float amp, float dur, float t)
{
    float val;
    float x;
    float gradient;
    
    if (type == "RISE")
    {
	x = (t / (dur)) * 2.0;
	if (x < 1.0)
	    val = pow(x, 2.0);
	else
	    val = 2 - pow((2 - x), 2.0);
	
	val = (val / 2.0);
	
	val *= amp;
	val += 0;		// vert dist.
    }
    else if (type == "FALL")
    {
	x = (t / (dur)) * 2.0;
	if (x < 1.0)
	    val = pow(x, 2.0);
	else
	    val = 2 - pow((2 - x), 2.0);
	
	val = (val / 2.0);
	
	val *= amp;
	val += 0;		// vert dist.
    }
    else
    {
	gradient = amp / dur;
	val = (gradient * t); // + el1->s_freq; vert dist.
    }
    
    return (val);
}

float weight(float duration)
{
    (void)duration;
    /*    return ((MAX_DUR + 0.7) - duration); */
    return(1.0);
}

float distance(EST_Track &fz, int pos, EST_Track &new_fz, int
	       num_points)
{
    int i;
    float distance = 0.0;
    float diff;
    
    for (i = 0; i < num_points; ++i)
    {
	diff = fz.a(i + pos) - new_fz.a(i);
	/*	    dprintf("o = %f, n = %f\n", old_contour[i + pos],
		    new_contour[i]);  */
	distance += (diff * diff);
    }
    return (distance); 
}


/* find index of contour given position in ms. Return -1 if */
float fncurve(float length, float t, float curve)
{
    float val;
    float x;
    
    x = (t / length) * 2.0;
    
    if (x < 1.0)
	val = pow(x, curve);
    else
	val = 2 - pow((2 - x), curve);
    
    val = val / 2.0;
    
    return (val);
}

