/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                 Authors:  Paul Taylor and Simon King                  */
/*                 Date   :  June 1995                                   */
/*-----------------------------------------------------------------------*/
/*                  Clustering algorithms main file                      */
/*                                                                       */
/*=======================================================================*/

#include <stdlib.h>
#include <fstream.h>
#include "EST_cluster.h"

int main(int argc, char *argv[])
{
    EST_String out_file, method;
    EST_StrList files;
    EST_Option al, op;
    //  float m[12][12];
    EST_FMatrix m;
    EST_CBK cbk;
    EST_TList<EST_String> ans;
    EST_TList<EST_String> names;
    EST_TBI *p;
    
    print_help(argc, argv);

    parse_command_line(argc, argv, "-d:f -method:s -names:s -o:s", files, al);

    init_lib_ops(al, op);
    out_file = al.present("-o") ? al.val("-o") : (EST_String)"-";
    
    m.load(files.first());
    cout << "m = " << m;
    
    if (al.present("-method"))
	method = al.val("-method");
    else
	method = "nn";
    
    init_cluster(cbk, m.num_rows());
    cluster(m, cbk, ans, method, names);
    
    ostream *outf;
    if (out_file == "-")
	outf = &cout;
    else
	outf = new ofstream(out_file);
    for (p = ans.head(); p != 0; p = next(p))
	*outf << ans(p) << endl;

    if (outf != &cout)
	delete outf;

    return 0;
}

void override_lib_ops(EST_Option &a_list, EST_Option &al)
{
    (void)a_list;
    (void)al;
}

void print_help(int argc, char *argv[])
{
    for (int i = 0;i < argc; ++i)
	if (strncmp(argv[i],"-help", 2) == 0)
	{
	    cout << "Usage:\n";
	    cout << "ch_lab  <input file> <output file> <options>\n";
	    cout << "use \"-\" to make input and output files stdin/out\n";
	    cout << "-N      do NOT read environment operations file\n";
	    cout << "-S      <float> frame spacing of output\n";
	    cout << "-class  <class name> Name of class defined in op file\n";
	    cout << "-color  <name> Color of output track\n";
	    cout << "-extend <factor> extend track file beyod label file";
	    cout << "-itype  <input file type 'xmg' 'ascii' 'esps' 'htk'>\n";
	    cout << "-length <ms float> length of track produced";
	    cout << "-name   <name> eg 'Fo', 'Phoneme'\n";
	    cout << "-off    vertical offset of track\n";
	    cout << "-ops    print relevant system options\n";
	    cout << "-otype  <output file type 'xmg' 'ascii' 'esps' 'htk'>\n";
	    cout << "-pad    <string> Pad with \"high\" or \"low\" values\n";
	    cout << "-pos    <label> list of labels to be regarded as `pos`";
	    cout << "-range  <float> difference between high and low values\n";
	    cout << "-shift   <float> shift the times of the labels\n";
	    cout << "-style  output style:, e.g. track\n";
	    cout << "-h      options help\n";
	    exit (0);
	}
}
