/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                    Author :  Paul Taylor                              */
/*                    Date   :  June 1996                                */
/*-----------------------------------------------------------------------*/
/*                    HMM Decode routine                                 */
/*                                                                       */
/*=======================================================================*/

#include "EST.h"
#include "HMM.h"

void default_options(EST_Option &al);
int save_pm(EST_String filename, EST_Track fz);

int main (int argc, char *argv[])
{
    EST_Wave sig;
    EST_Option al, op;
    EST_String out_file;
    HMM model;
    EST_StrList files;
    
    print_help(argc, argv);
    parse_command_line(argc, argv, "-m:s", files, al);

//    read_wave(sig, files.first(), al);
//    out_file = files[num_files - 1];
    
    if (model.load(al.val("-m")) != read_ok)
	cerr << "Error in loading model\n";

    cout << model;
}

// addded by simonk
void override_lib_ops(EST_Option &a_list, EST_Option &al)
{
    (void) a_list;
    (void) al;
}
    
/* removed by simonk
void parse_command_line(Option &a_list, Option &al)
{

}
*/

void print_help(int argc, char *argv[])
{
    for (int i = 0; i < argc; ++i)
	if (strncmp(argv[i],"-help", 2) == 0)
	{
	    cout << "Usage:\n";
	    cout << "hmm_decode  <input file> <output file> <options>\n";
	    cout << "-h      options help\n";
	    
	    exit (0);
	}
}


