/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                         Copyright (c) 1996                            */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                 Author :  Alan Black and Paul Taylor                  */
/*                 Date   :  June 1996                                   */
/*-----------------------------------------------------------------------*/
/*               General low level wave utils (C and C++)                */
/*  Conversion routines and lowest level file format independent read    */
/*  and write functions                                                  */
/*                                                                       */
/*=======================================================================*/
#ifndef __EST_WAVE_UTILS_H__
#define __EST_WAVE_UTILS_H__

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include "EST_cutils.h"
#include "EST_rw_status.h"
#include "EST_wave_types.h"

void ulaw_to_short(unsigned char *ulaw,short *data,int length);
void char_to_short(unsigned char *chars,short *data,int length);
void short_to_char(short *data,unsigned char *chars,int length);
void short_to_ulaw(short *data,unsigned char *ulaw,int length);

void ConvertToIeeeExtended(double num,unsigned char *bytes);
double ConvertFromIeeeExtended(unsigned char *bytes);

int get_word_size(enum EST_sample_type_t sample_type);
enum EST_sample_type_t str_to_sample_type(const char *type);
char *sample_type_to_str(enum EST_sample_type_t type);
char *file_format_to_str(enum EST_file_format_t type);
enum EST_file_format_t str_to_file_format(const char *type);

short *convert_raw_data(unsigned char *file_data,int data_length,
			enum EST_sample_type_t sample_type,int bo);
enum EST_write_status save_raw_data(FILE *fp, short *data, int offset,
			       int num_samples, int num_channels, 
			       enum EST_sample_type_t sample_type, int bo);
    
#ifdef __cplusplus
}
#endif

#endif /* __EST_WAVE_UTILS_H__ */
