#!/usr/local/bin/perl
$| = 1;

print "Bulk Configuration of CGIWrap\n";
print "Reading 'config.sh'... ";
@CONFIG = ();

open(CONFIG, "config.sh") || die "couldn't open config.sh";
while ( $_ = <CONFIG> )
{
	chop $_;
	push(@CONFIG, $_);
}
close(CONFIG);
print "done.\n";

print "Backing up 'config.sh'... ";
system("cp config.sh config.sh.sv");
print "done.\n";

print "\nUserID: ";
chop($conf_userid = <STDIN>);

print "\nServer Port: ";
chop($conf_port = <STDIN>);

print "\nServer Name: ";
chop($conf_hostname = <STDIN>);

print "\nCGI Dir (i.e. public_html/cgi-bin): ";
chop($conf_cgidir = <STDIN>);

print "\n";
print "Writing new 'config.sh'...\n";

open(CONFIG, ">config.sh") || die "couldn't open config.sh";
foreach $f ( @CONFIG )
{
	if ( $f =~ /^httpd_user='/ )
	{
		print CONFIG "httpd_user='$conf_userid'\n";
	}
	elsif ( $f =~ /^conf_log_label='/ )
	{
		print CONFIG "conf_log_label='$conf_hostname-$conf_userid-$conf_port'\n";
	}
	elsif ( $f =~ /^conf_cgidir='/ )
	{
		print CONFIG "conf_cgidir='$conf_cgidir'\n";
	}
	else
	{
		print CONFIG "$f\n";
	}
}
close(CONFIG);

