/* utility routines for the coutner */

#include "cdebug.h"

#include "combine.h"
#include "gdfonts.h"
#include "count.h"

#ifdef SYS_WIN32
#include "configNT.h"
#else
#include "config.h"
#endif


static int howmanyCommas _Declare((char *));
static unsigned long my_inet_addr _Declare ((char *));

/*
**  howmanyCommas()
**  calculates how many commas will be added to the buffer
**
**  RCS
**      $Revision$
**      $Date$
**  Return Values:
**      no of commas 
**
**  Parameters:
**      buf     buf to scan
**
**  Side Effects:
**      none
**
**  Limitations and Comments:
**      buf must be a initialized string (at least)
**
**  Development History:
**      who                  when           why
**      ma_muquit@fccc.edu   Oct-18-1997    first cut
*/
static int howmanyCommas(buf)
char
    *buf;
{
    int
        n=0,
        length;

    if (*buf == '\0')
        return(0);

    length=strlen(buf);

    if ((length % 3) == 0)
        n=(length/3)-1;
    else
        n=length/3;

    if ( n < 0)
        n=0;

    Debug2("no of commas=%d",n,0);
    return(n);
}


/*
**  Commaize()
**  add a comma after every 3rd digit from right
**
**  RCS
**      $Revision$
**      $Date$
**  Return Values:
**      none
**
**  Parameters:
**      buf     buf to modify
**
**  Side Effects:
**      buf is modified if it is atleast 4 character long
**
**  Limitations and Comments:
**      none
**
**  Development History:
**      who                  when       why
**      ma_muquit@fccc.edu   no idea    first cut
**                           Oct-18-97  added dynamic buffer 
*/


void Commaize(buf)
char
    *buf;
{
    char
        *pbuf=(char *) NULL;

    register char
        *p,
        *q;

    int
        ncommas=0,
        m=0,
        i=-1;


    if (*buf != '\0')
    {
        ncommas=howmanyCommas(buf);
        if (ncommas > 0) /* atleat 4 characters */
        {
            pbuf=(char *) malloc(strlen(buf)+ncommas*sizeof(char)+1);
            if (pbuf == (char *) NULL)
            {
                /* return quietly */
                return;
            }
        }
        m=0;
        m=m+strlen(buf)/3;
        if (strlen(buf)%3 == 0)
            m--;

        p=buf+strlen(buf)-1;
        pbuf[strlen(buf)+m]='\0';
        q=pbuf+strlen(buf)+m-1;
        while (1)
        {
            if (p < buf)
                break;
            if (++i == 3)
                i=0, *q-- = ',';
             *q-- = *p--;
        }
        (void) strcpy(buf,pbuf);
        if (pbuf)
            (void) free(pbuf);
    }

}


void PrintHeader ()
{
    if (Gdebug == False)
    {
        (void) fprintf (stdout,
            "Content-type: image/gif%c%c",LF,LF);
        (void) fflush (stdout);
    }
    return;
}

/*
** check if the counter file exists
*/

int CheckFile (filename)
char
    *filename;
{
    int
        rc=0;

    rc = access (filename, F_OK);
    return rc;
}

/*
 * checkfilename:
 * - check to see if a path was specified - return 1 if so, 0 otherwise
 * it might not be foolproof, but I can't come up with
 * any other ways to specify paths.
 * by carsten@group.com (07/27/95)
 * ..\filename was not getting ignored on NT
 * reported by asolberg@pa.net>
 * fixed: 04/19/96
 */

int checkfilename(str)
char
    *str;
{
    while (*str)
    {
        if ((*str == '/') || 
            (*str == '\\') || 
            (*str == ':') ||
            (*str == '~'))
            return 1;
        str ++;
    }
    return 0;
}

/*
**  cMalloc()
**  a wrapper around malloc
**
**  RCS
**      $Revision$
**      $Date$
**  Return Values:
**      returns a pointer to allocated space
**
**  Parameters:
**      size    bytes to malloc
**
**  Side Effects:
**      space is allocated
**
**  Limitations and Comments:
**      will write the error message image and exit
**
**  Development History:
**      who                  when           why
**      ma_muquit@fccc.edu   Oct-12-1997    first cut
*/

char *cMalloc(size)
int
    size;
{
    char
        *ptr;

    ptr=(char *) malloc(size);

    if (ptr == NULL)
    {
        PrintHeader();
        StringImage("Memory allocation problem!");
        exit(0);
    }

    return(ptr);
}


/*
** NULL terminate the buffer at the first sigt of a non-digit character
*/
void cleanBuf(buf,bytes_in_buf,length)
char
    *buf;
int
    bytes_in_buf;
int
    *length;
{
    int
        i;


    int
        c=0;
    for (i=0; i < bytes_in_buf; i++)
    {
        if (!isdigit(buf[i]))
        {
            buf[i]='\0';
            break;
        }
        c++;
    }

    *length=c;
}
/*
**  safeStrcpy()
**  copy a string to another safely without overflowing buffer
**
**  RCS
**      $Revision$
**      $Date$
**  Return Values:
**      none
**
**  Parameters:
**      to_str      destination buffer
**      from_str    source buffer
**      length      max allowable length of the from_str
**
**  Side Effects:
**      if copying is safe, to_str buffer is modified.
**
**  Limitations and Comments:
**      if the source string is longer than length, it's truncated to
**      length. to_str must be static or dynamically allocated buffer, that
**      is it must be able to hold atleast lenth bytes buffer. The from_str
**      is checked if it is NULL or not. if NULL the routine will exit 
**      after writing an error message image.
**      
**
**  Development History:
**      who                  when           why
**      ma_muquit@fccc.edu   Oct-17-1997    first cut
*/

void safeStrcpy(to_str,from_str,length)
char
    *to_str,
    *from_str;
int
    length;
{
    if (*from_str == '\0')
    {
        PrintHeader();
        StringImage("Source buffer is NULL in safeStrcpy()!");
        exit(0);
    }

    if (strlen(from_str) > length)
    {
        PrintHeader();
        StringImage("buffer overflow detected! aborting");
        exit(0);
    }

    /* now copy */
    (void) strncpy(to_str,from_str,length);
}


/* just like safeStrcpy(), it is safe strncat() */
void safeStrcat(to_str,str,length)
char
    *to_str,
    *str;
int
    length;
{
    if (*str == '\0')
    {
        PrintHeader();
        StringImage("Source buffer is NULL in safeStrncat()!");
        exit(0);
    }

    if (strlen(str) > length)
    {
        PrintHeader();
        StringImage("buffer overflow detected! aborting");
        exit(0);
    }

    /* now copy */
    (void) strncat(to_str,str,length);
}
/* case insensitive version of ANSI strstr() */
/* from swish package by kevin h , kevin called it lstrstr()*/
char *stristr(s, t)
char
    *s;
char
    *t;
{

int
    i,
    j,
    k,
    l;

    for (i = 0; s[i]; i++) 
    {
        for (j = 0, l = k = i; s[k] && t[j] &&
        tolower(s[k]) == tolower(t[j]); j++, k++)
            ;
        if (t[j] == '\0')
            return s + l;
    }
    return NULL;
}

/*
**  authRemhost()
**  authenticare remote host
**
**  RCS
**      $Revision$
**      $Date$
**  Return Values:
**      returns (1) only if host is authorized. othewise writes the error
**      message image and exits
**
**  Parameters:
**      none
**
**  Side Effects:
**      none
**
**  Limitations and Comments:
**      none
**
**  Development History:
**      who                  when           why
**      ma_muquit@fccc.edu   Oct-18-1997    first cut
*/

int authRemhost()
{
    int
        rc=0;

    char
        *prem_refh=(char *) NULL,
        szHttp_ref[1024],
        szRhost[1024];

    Sllist
        *llp;

    *szHttp_ref='\0';
    *szRhost='\0';

    prem_refh=(char *) getenv("HTTP_REFERER");
    if (prem_refh != (char *) NULL)
    {
        safeStrcpy(szHttp_ref,prem_refh,sizeof(szHttp_ref)-1);
        GetRemoteReferer(szHttp_ref,szRhost);

        if (*szRhost != '\0')
        {
            if (Grhost > 0)
            {

                for (llp=g_refhost;llp;llp=llp->next)
                {
                    rc=isinname(szRhost,llp->item);
                    if (rc == 1)    /* allowed */
                        return(1);
                }
            }
            if (rc == 0)
            {
                *szHttp_ref='\0';
                (void) sprintf(szHttp_ref,"Host: \"%s\" is not authorized",
                               szRhost);
                Warning(szHttp_ref);

                PrintHeader();
                StringImage(szHttp_ref);
                exit(0);
            }
        }
    }
    else
        rc=1;

    return (rc);
}


/*
**  isinname()
**  checks if the mask fits in the string
**
**  RCS
**      $Revision$
**      $Date$
**  Return Values:
**      1       if fits
**      0       if not
**
**  Parameters:
**      string      source string
**      mask        mask string
**
**  Example:
**      www.fccc.edu  *.fccc.edu        fits
**      www.fccc.edu  www*              fits
**      www.fccc.edu  *fccc*            fits
**      132.138.4.6   132*              fits
**      etc.....
**
**  Side Effects:
**      none
**
**  Limitations and Comments:
**      borrowed from swish by Kevin H
**
**  Development History:
**      who                  when           why
**      ma_muquit@fccc.edu   Oct-18-1997    first cut
*/

int isinname(string, mask)
char
    *string;
char
    *mask;
{
    int
        i,
        j;

    char
        firstchar,
        lastchar,
        *tempmask;

    if ((*string == '\0') || (*mask == '\0'))
        return (0); /* mm */

    if (!strcmp(mask, "*"))
            return 1;

    firstchar=mask[0];
    lastchar=mask[(strlen(mask) - 1)];
    tempmask=(char *) malloc(strlen(mask));

    for (i = j = 0; mask[i]; i++)
        if (mask[i] != '*')
            tempmask[j++] = mask[i];

    tempmask[j]='\0';
    if (firstchar == '*')
    {
        if (lastchar == '*')
        {
            if ((char *) stristr(string, tempmask))
            {
                free(tempmask);
                return 1;
            }
        }
        else
        {
            if ((char *) stristr(string, tempmask) ==
                 string + strlen(string) - strlen(tempmask))
            {
                free(tempmask);
                return 1;
            }
        }
    }
    else if (lastchar == '*')
    {
        if ((char *) stristr(string, tempmask) == string)
        {
            free(tempmask);
            return 1;
        }
    }
    else
    {
        if (!strcmp(string, tempmask))
        {
            free(tempmask);
            return 1;
        }
    }
    free(tempmask);

    return 0;
}



/*
** get current time
*/

char *GetTime ()
{
    time_t
        tm;

    char
        *times;

    tm = time (NULL);
    times = ctime(&tm);
    times[(int) strlen(times)-1] = '\0';
    return (times);
}

void Warning (message)
char
    *message;
{
    char
        *times;
    FILE
        *fp= (FILE *) NULL;
    char
        buf[1024];

    *buf='\0';
    (void) sprintf(buf,"%s/%s",LogDir,LogFile);
    times = GetTime();
    fp = fopen(buf, "a");

    if (fp == (FILE *) NULL)
    {
        (void) fprintf (stderr,"[%s] Count %s: Could not open CountLog file %s/%s\n ",times, Version, LogDir,LogFile);
        fp = stderr;
    }
        (void) fprintf (fp,"[%s] Count %s: %s\n", 
            times, Version,message);
    if (fp != stderr)
        (void) fclose (fp);
}



/*
 * Copyright (c) 1988, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
** I'm renaming it to mystrtok() in order to avoid conflict with the
** system which might have it
** I also formatted to my coding style
** 10/08/95, muquit@semcor.com
*/

char *mystrtok(s, delim)
char
    *s;
char
    *delim;
{
	register char
        *spanp;

	register int
        c,
        sc;

	char
        *tok;

	static char
        *last;


	if (s == (char *) NULL && (s = last) == (char *) NULL)
		return ((char *) NULL);

	 /*
	 ** Skip (span) leading delimiters (s += strspn(s, delim), sort of).
	 */
cont:
	c = *s++;
	for (spanp = (char *)delim; (sc = *spanp++) != 0;) 
    {
		if (c == sc)
			goto cont;
	}

	if (c == 0) 
    {		/* no non-delimiter characters */
		last = (char *) NULL;
		return ((char *)NULL);
	}
	tok = s - 1;

	/*
	 * Scan token (scan for delimiters: s += strcspn(s, delim), sort of).
	 * Note that delim must have one NUL; we stop if we see that, too.
	 */

	for (;;) 
    {
		c = *s++;
		spanp = (char *)delim;
		do 
        {
			if ((sc = *spanp++) == c) 
            {
				if (c == 0)
					s = (char *) NULL;
				else
					s[-1] = '\0';
				last = s;
				return (tok);
			}
		} while (sc != 0);
	}
	  /* NOTREACHED */
}


/*
** found somewhere in the net
** muquit@semcor.com
*/
int mystrcasecmp(a,b)
char
    *a,
    *b;
{	
    register char
        ac,
        bc;

	for(;;)
    {
		ac = *a++;
		bc = *b++;

		if(ac == 0)
        {
			if(bc == 0)
				return 0;
			else
                return -1;
        }
		else
        { 
            if(bc == 0)
				return 1;
			else 
            {
                if(ac != bc)
                {
					if(islower(ac)) ac = toupper(ac);
					if(islower(bc)) bc = toupper(bc);
					if( ac != bc )
						return ac - bc;
				}
            }
	    }
    }
}


int CheckDirs()
{
    if ((strcmp(ConfigDir,DigitDir) == 0) ||
        (strcmp(ConfigDir,DataDir) == 0) ||
        (strcmp(ConfigDir,LogDir) == 0) ||
        (strcmp(ConfigDir,LogDir) == 0) ||
        (strcmp(DigitDir,DataDir) == 0) ||
        (strcmp(DigitDir,LogDir) == 0) ||
        (strcmp(DataDir,LogDir) == 0))
    return (1);
return (0);
}



/*
 * the different -- and hopefully self-contained -- version of
 * CheckRemoteIP. Main difference is that ignore host block may
 * contain two IP address fields. First is then IP network address
 * and second is the netmask to be applied for comparision.  
 *
 * Davorin Bengez (Davorin.Bengez@science.hr), Jan 11. 1996.
 */

int CheckRemoteIP(remote_ip,ip_ign)
char *remote_ip, *ip_ign;
{
    unsigned long
        rem_ip,
        ignore_ip,
        ignore_mask;

    char
        addr_buf[20],
        mask_buf[20];

    int
        rc=False,
        i;

    ignore_mask = 0xffffffffL;

    rem_ip = my_inet_addr(remote_ip);
    if(rem_ip == (unsigned long)-1) return(False);

    /*
     * if ip_ign has TWO ip-look-alike fields, second field is netmask
     */

    if((i = sscanf(ip_ign, "%s %s", addr_buf, mask_buf)) < 1)
    {
        return(False);
    }
    ignore_ip = my_inet_addr(addr_buf);
    if (ignore_ip == (unsigned long)-1)
        return(False);

    /*
     * try to convert the mask to something usable and fail if it
     * is not the proper IP netmask...
     */

    if(i == 2)  /* with netmask */
    {
        Debug2("in netmask ==> ignore IP=%s",ip_ign,0);
        ignore_mask = my_inet_addr(mask_buf);
        if(ignore_mask == (unsigned long)-1)
            return(False);

        /*
         * ...and finally, compare the masked addresses...
         */
  
        if((rem_ip & ignore_mask) == (ignore_ip & ignore_mask))
            return(True);
        else
            return(False);
    }
    else if (i == 1)  /* a single IP or wild card */
    {
        Debug2("in sing/wildcard ==> ignore IP=%s",ip_ign,0);
        rc=isinname(remote_ip,ip_ign);
        Debug2("ignore %s=%d",remote_ip,rc);
        return (rc);
    }

    return (False);
}

/*
 * and a version of inet_addr - not to link all the network services
 * just because of this one...
 */

static unsigned long my_inet_addr(s)
char *s;
{
    unsigned long n;
    int i;

    n = 0;

    for(i = 24; i >= 0; i -= 8) {
        n |= (unsigned long)atoi(s) << i;
        if((s = strchr(s,'.')) == (char *)NULL)
            break;
        ++s;
    }
    return(n);
}
