
import java.sql.*;


/**
 * test getting timestamps from the database.
 *
 */
public class t0004
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException 
   {
      boolean    passed = true;

      System.out.println("test getting timestamps from the database.");

      // open the database
      Class.forName("com.internetcds.jdbc.tds.Driver");
      
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();
      
      try
      {
         stmt.executeUpdate("drop table t0004");
      }
      catch (SQLWarning e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0004', because it does")))
         {
            System.out.println("|" + e.getMessage() + "|");
            throw e;
         }
      }
      
      count = stmt.executeUpdate("create table t0004              "
                                 + "  (mytime  datetime not null, "
                                 + "   mytime2 datetime null,     "
                                 + "   mytime3 datetime null     )");
      System.out.println("Creating table affected " + count + " rows");
      
      PreparedStatement  pStmt = cx.prepareStatement(
         "insert into t0004 values ('1998-09-09 15:35:05', ?, ?)");
      
      Timestamp   t0 = new Timestamp(98, 8, 9, 15, 35, 5, 0);
      pStmt.setTimestamp(1, t0);
      pStmt.setTimestamp(2, t0);
      count = pStmt.executeUpdate();
      System.out.println("Added " + count + " rows");

      pStmt.setNull(2, java.sql.Types.TIMESTAMP);
      count = pStmt.executeUpdate();
      System.out.println("Added " + count + " rows");
      
      pStmt = cx.prepareStatement(
         "select mytime, mytime2, mytime3 from t0004");
      

      ResultSet  rs = pStmt.executeQuery();
   
      while(rs.next())
      {
         Timestamp   t1;

         System.out.print("mytime:   ");
         t1 = rs.getTimestamp(1);
         if (rs.wasNull())
         {
            System.out.println("null");
         }
         else
         {
            System.out.println(t1);
         }

         System.out.print("mytime1:  ");
         t1 = rs.getTimestamp(2);
         if (rs.wasNull())
         {
            System.out.println("null");
         }
         else
         {
            System.out.println(t1);
         }

         System.out.print("mytime2:  ");
         t1 = rs.getTimestamp(3);
         if (rs.wasNull())
         {
            System.out.println("null");
         }
         else
         {
            System.out.println(t1);
         }
      }

      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0004.\n");
      System.exit(passed ? 0 : 1);
   }
}

