
import java.sql.*;


/**
 * test inserting integer null with prepared statement
 *
 */
public class t0042
{

   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException 
   {
      boolean    passed = true;

      System.out.println("test inserting null integers with prepared statement");

      // open the database
      Class.forName("com.internetcds.jdbc.tds.Driver");
      

      int           i;
      int           count    = 0;
      Connection    cx       = Common.getConnection();
      Statement     stmt     = cx.createStatement();


         
      
      try
      {
         stmt.executeUpdate("drop table t0042");
      }
      catch (SQLWarning e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0042', because it does")))
         {
            System.out.println("|" + e.getMessage() + "|");
            throw e;
         }
      }
      
      count = stmt.executeUpdate("create table t0042 (s char(5) null, i integer null)");
      System.out.println("Creating table affected " + count + " rows");
      

      PreparedStatement   pStmt1   = cx.prepareStatement("insert into t0042 (s, i) values (?, ?)");
      PreparedStatement   pStmt2   = cx.prepareStatement("select i from t0042");

      pStmt1.setString(1, "hello");
//      pStmt1.setInt(2, 17);
      pStmt1.setNull(2, java.sql.Types.INTEGER);
      count = pStmt1.executeUpdate();
      passed = passed && count==1;
System.out.println("The returned count is " + count);

System.out.println("Inserted first item.  passed is " + passed);

      pStmt1.setInt(2, 42);
      count = pStmt1.executeUpdate();
      passed = passed && count==1;

System.out.println("Inserted 2nd item.  passed is " + passed);
               
      ResultSet  rs = pStmt2.executeQuery();
      passed = passed && rs != null;

System.out.println("got the result set.  passed is " + passed);
      
      passed = passed && rs.next();
      rs.getInt(1);
      passed = passed && rs.wasNull();

System.out.println("got 1st item.  passed is " + passed);
               

      passed = passed && rs.next();
      passed = passed && rs.getInt(1)==42 && !rs.wasNull();
      
      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0042.\n");
      System.exit(passed ? 0 : 1);
   }
}

