/*
 *  Sarien AGI :: Copyright (C) 1999 Dark Fiber 
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __AGI_PICTURE
#define __AGI_PICTURE

#ifdef __cplusplus
extern "C"{
#endif

typedef struct CORD
{
	struct CORD *next;
	UINT16	x, y;
} CORD;


typedef struct AGI_PICTURE
{
	UINT32	flen;			/* size of raw data */
	UINT8	*rdata;			/* raw vector image data */
	UINT8	*sdata;			/* screen bitmap image */
	UINT8	*pdata;			/* priority bitmap image */
	UINT8	*cdata;			/* control lines image */
	UINT8	*xdata;			/* combined p+c images */
} AGI_PICTURE;

/* kludge */
extern UINT8	sprite_data[];
extern UINT8	screen_data[];
extern UINT8	screen2[];
extern UINT8	xdata_data[];
extern UINT8	control_data[];
extern UINT8	priority_data[];
extern UINT8	pic_clear_flag;

extern	AGI_PICTURE	pictures[];

UINT16		decode_picture (UINT16 resnum);
UINT16		unload_picture (UINT16 resnum);

void		dump_screen (UINT16 resnum);
void		dump_pri (UINT16 resnum);
void		dump_con (UINT16 resnum);
void		dump_x (UINT16 resnum);

void		dump_pri_screen (void);
void		dump_con_screen (void);
void		dump_x_screen (void);
void		dump_screenX (void);
void		dump_screen2 (void);
void		put_block_buffer (UINT8 *, UINT16, UINT16, UINT16, UINT16);
UINT8* 		convert_v2_v3_pic(UINT8 *data, UINT32 len);
void 		reset_graphics(void);

#ifdef __cplusplus
};
#endif
#endif
