/*
 *  Sarien AGI :: Copyright (C) 1999 Dark Fiber 
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SARIEN_H
#define __SARIEN_H

#ifdef HAVE_GETOPT_LONG
#define ELIDE_CODE
#endif

#if defined (NATIVE_WIN32)
#define INLINE __forceinline
#elif !defined (INLINE)
#define INLINE
#endif


typedef unsigned char	UINT8;
typedef unsigned short	UINT16;
typedef unsigned long	UINT32;
typedef signed char	SINT8;
typedef signed short	SINT16;
typedef signed long	SINT32;

typedef unsigned int	UINT;
typedef signed int	SINT;

#define __TRUE		1
#define __FALSE		0


#define	TITLE		"Sarien"

#ifdef NATIVE_WIN32
#define VERSION "Win32 native experimental version"
#endif

#define DIR		"dir."

#define LOGDIR		"logdir"
#define PICDIR		"picdir"
#define VIEWDIR		"viewdir"
#define	SNDDIR		"snddir"
#define OBJECTS		"object"
#define WORDS		"words.tok"

#define	MAX_DIRS	256
#define	MAX_VARS	256
#define	MAX_FLAGS	256
#define MAX_VIEWTABLE	64
#define MAX_WORDS	20
#define MAX_WORDS1	24
#define	MAX_WORDS2	40

#define	_EMPTY		0xFFFFF
#define	EGO_OWNED	0xFF

#define	CRYPT_KEY_SIERRA	"Avis Durgan"
#define CRYPT_KEY_AGDS		"Alex Simkin"

#define	MSG_BOX_COLOUR	0xF		/* White */
#define MSG_BOX_TEXT	0x0		/* Black */
#define MSG_BOX_LINE	0x4		/* Red */
#define MENU_BG		0xF		/* White bg */
#define MENU_FG		0x0		/* Black fg */
#define MENU_LINE	0x0		/* Black line */
#define	STATUS_BG	0xF		/* White */
#define STATUS_FG	0x0		/* Blue */
#define STATUS_FG_CLEAN	0x0		/* Black */


#define AGDS_SUPPORT			/* enable support for AGDS games */
#define	DISABLE_COPYPROTECTION		/* only works on some games */
				/* currently only KQ4, GR, LSL1 */


#define EGO_VIEW_TABLE	0

#define	HORIZON			36

#define _WIDTH			160
#define _HEIGHT			168

#ifdef _TRACE
#define _D(y) do {							\
	printf ("* " __PRETTY_FUNCTION__ " [%s:%d] ", __FILE__, __LINE__); \
	printf y;							\
	printf ("\n");							\
} while (0)
#else
#define _D(y)
#endif


#ifdef __cplusplus
extern "C"{
#endif

extern	UINT8	optForce;
extern	UINT8	optCache;
extern	UINT8	optPCJrGFX;
extern	UINT8	optGameRun;
extern	UINT8	optShowScreenDraw;
extern	UINT8	optShowKeyPress;
extern	UINT16	optEmuVersion;
extern	UINT8	optDebug;
extern	UINT8	optScale;
extern	UINT8	optAGDS;
extern	UINT8	optAmiga;

extern	UINT16	parse_cli(int, char **);


#if 0
extern	UINT8	o_score;
extern	UINT8	o_sound;
extern	UINT8	o_status;
#endif

/**************************************************************************/
UINT8	lohi_getbyte	(UINT8 *mem);
UINT16	lohi_getword	(UINT8 *mem);
UINT32	lohi_getpword	(UINT8 *mem);
UINT32	lohi_getdword	(UINT8 *mem);

UINT8	hilo_getbyte	(UINT8 *mem);
UINT16	hilo_getword	(UINT8 *mem);
UINT32	hilo_getpword	(UINT8 *mem);
UINT32	hilo_getdword	(UINT8 *mem);

void	fixpath		(UINT8 flag, UINT8 *fname);

UINT8	getflag		(UINT32 number);
void	setflag		(UINT32 number, UINT8 value);
void	flipflag	(UINT32 number);

UINT8	getvar		(UINT32 var);
void	setvar		(UINT32 var, UINT8 val);

void	decrypt		(UINT8 *mem, UINT32 len);
void	unload_resources(void);
void	release_sprites	(void);
void	new_room_resources(void);
void	update_status_line(UINT8);

void main_cycle (UINT8);

#ifdef __cplusplus
};
#endif



extern	volatile UINT32	clock_ticks;
extern	volatile UINT32 clock_count;
extern	volatile UINT32	msg_box_secs2;

extern	UINT16	init_machine(int, char **);
extern	UINT16	deinit_machine(void);
extern	UINT8	__file_exists(UINT8 *fname);
extern	UINT8*	__file_name(UINT8 *fname);



#define ID_NONE		0x00000000
#define ID_AGDS		0x00000001
#define ID_AMIGA	0x00000002

#ifdef __cplusplus
extern "C"{
#endif

UINT32 v2id_game (void);
UINT32 v3id_game (void);

#ifdef __cplusplus
};
#endif


enum {
	NO_GAMEDIR=0,
	GAMEDIR
};

enum {
	V_cur_room = 0,
	V_prev_room,
	V_border_touch_ego,
	V_score,
	V_border_code,
	V_border_touch_obj,		/* 5 */
	V_ego_dir,
	V_max_score,
	V_free_pages,
	V_word_not_found,
	V_time_delay,                   /* 10 */
	V_seconds,
	V_minutes,
	V_hours,
	V_days,
	V_joystick_sensitivity,         /* 15 */
	V_ego_view_resource,
	V_agi_err_code,
	V_agi_err_code_info,
	V_key,
	V_computer,                     /* 20 */
	V_window_reset,
	V_soundgen,
	V_Volume,
	V_max_input_chars,
	V_sel_item,                     /* 25 */
	V_monitor
};

enum {
	F_ego_water=0,
	F_ego_invis,
	F_entered_cli,
	F_ego_touched_p2,
	F_said_accepted_input,
	F_new_room_exec,				/* 5 */
	F_restart_game,
	F_script_blocked,
	F_joy_sensitivity,
	F_sound_on,
	F_debugger_on,					/* 10 */
	F_logic_zeron_firsttime,
	F_restore_just_ran,
	F_status_selects_items,
	F_menus_work,					/* 14 */
	F_output_mode
};


enum error {
	err_OK=0,
	err_DoNothing,
	err_BadCLISwitch,
	err_InvalidAGIFile,
	err_BadFileOpen,
	err_NotEnoughMemory,
	err_BadResource,
	err_UnknownAGIVersion,
	err_RestartGame,
	err_NoLoopsInView,
	err_ViewDataError,

	err_Unk=127
};

enum RESOURCES {
	rLOGIC=1,
	rSOUND,
	rVIEW,
	rPICTURE
};

enum {
	gRUN_GAME=1,
	gSHOW_WORDS,
	gSHOW_OBJECTS,
	gVIEW_PICTURES
};

enum {
	RES_LOADED=1,
	RES_CACHED=2,
	RES_COMPRESSED=0x40
};

enum {
	lCOMMAND_MODE=1,
	lTEST_MODE
};

enum {
	eKEY_PRESS=1,
	eSCAN_CODE,
	eMENU_PRESS
};

enum {
	player_control=1,
	program_control
};

enum {
	GFX_MODE=1,
	TXT_MODE
};

enum {
	SAVE=1,
	NO_SAVE
};

enum {
	LINES=1,
	NO_LINES,
	BX_SAVE=0x10
};

enum {
	MOTION_NORMAL=1,
	MOTION_WANDER,
	MOTION_FOLLOW_EGO,
	MOTION_MOVE_OBJ
};

enum {
	CYCLE_NORMAL=1,
	CYCLE_END_OF_LOOP,
	CYCLE_REV_LOOP, 
	CYCLE_REV
};
#endif
