/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.parser;

import java.io.IOException;
import java.io.Reader;
import org.openxml.DOMFactory;
import org.openxml.DTDDocument;
import org.openxml.XMLBookmarks;
import org.openxml.io.HTMLDTD;
import org.openxml.parser.ContentParser;
import org.openxml.parser.ParseException;
import org.openxml.source.Holder;
import org.openxml.source.Source;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLPreElement;
import org.w3c.dom.html.HTMLScriptElement;
import org.w3c.dom.html.HTMLStyleElement;

public final class HTMLParser
extends ContentParser {
    private StringBuffer _nodeText = new StringBuffer();
    private boolean _nodeTextSpace;
    private String _orphanClosingTag;
    private XMLBookmarks _bookmarks;

    public HTMLParser(Reader reader, String string) {
        this(reader, string, 11, 0);
    }

    public HTMLParser(Reader reader, String string, short s, short s2) {
        super(reader, string, s, s2);
    }

    private boolean closingTag(boolean bl) throws ParseException {
        if (!(this._currentNode instanceof HTMLElement)) {
            return true;
        }
        String string = this._tokenText.toString();
        HTMLElement hTMLElement = (HTMLElement)this._currentNode;
        if (hTMLElement.getTagName().equalsIgnoreCase(string)) {
            return false;
        }
        Node node = this._currentNode.getLastChild();
        while (node != null) {
            if (node instanceof HTMLElement && (hTMLElement = (HTMLElement)node).getTagName().equalsIgnoreCase(string)) {
                if (hTMLElement.hasChildNodes() || !HTMLDTD.supportsChildren(hTMLElement)) break;
                while (hTMLElement.getNextSibling() != null) {
                    hTMLElement.appendChild(hTMLElement.getNextSibling());
                }
                this.loseWhitespace(hTMLElement);
                return true;
            }
            node = node.getPreviousSibling();
        }
        this._orphanClosingTag = string;
        if (!bl) {
            this.error((short)1, "Closing tag '" + string.toUpperCase() + "' does not match with opening tag'" + hTMLElement.getTagName() + "'.");
        }
        return true;
    }

    private void loseWhitespace(HTMLElement hTMLElement) {
        String string;
        Node node = hTMLElement.getFirstChild();
        if (node != null && node instanceof Text) {
            string = ((Text)node).getData();
            if (string.length() == 1 && string.charAt(0) == ' ') {
                hTMLElement.removeChild(node);
            } else if (string.length() > 0 && string.charAt(0) == ' ') {
                ((Text)node).deleteData(0, 1);
            }
        }
        if ((node = hTMLElement.getLastChild()) != null && node instanceof Text) {
            string = ((Text)node).getData();
            if (string.length() == 1 && string.charAt(0) == ' ') {
                hTMLElement.removeChild(node);
            } else if (string.length() > 0 && string.charAt(string.length() - 1) == ' ') {
                ((Text)node).deleteData(string.length() - 1, 1);
            }
        }
    }

    protected final void parseDTDSubset() throws ParseException, IOException {
        String string = null;
        String string2 = null;
        while (this.isSpace(this.readChar())) {
        }
        this.pushBack();
        if (this.readTokenName()) {
            if (!this._tokenText.equals("HTML")) {
                this.error((short)1, "Only 'HTML' supported as root element in HTML document.");
            }
            while (this.isSpace(this.readChar())) {
            }
            if (this._curChar == 83 && this.canReadName("YSTEM")) {
                while (this.isSpace(this.readChar())) {
                }
                this.pushBack();
                if (this.readTokenQuoted()) {
                    string2 = this._tokenText.toString();
                } else {
                    this.error((short)1, "Document type definition missing quoted system identifier.");
                }
            } else if (this._curChar == 80 && this.canReadName("UBLIC")) {
                while (this.isSpace(this.readChar())) {
                }
                this.pushBack();
                if (this.readTokenQuoted()) {
                    string = this._tokenText.toString();
                    while (this.isSpace(this.readChar())) {
                    }
                    this.pushBack();
                    if (this.readTokenQuoted()) {
                        string2 = this._tokenText.toString();
                    } else {
                        this.error((short)1, "Document type definition missing quoted system identifier.");
                    }
                } else {
                    this.error((short)1, "Document type definition missing quoted public identifier.");
                }
            } else {
                this.pushBack();
            }
            if (string2 != null || string != null) {
                Source source = DOMFactory.newSource();
                source.setURI(string2);
                source.setPublicId(string);
                source.setDocClass(Source.DOCUMENT_DTD);
                Holder holder = DOMFactory.getHolderFinder().findHolder(source, false);
                if (holder != null) {
                    this._docType = (DTDDocument)holder.newInstance();
                } else {
                    this.error((short)1, "Could not locate external DTD subset.");
                }
            }
        } else {
            this.error((short)1, "Document type definition missing root element type and was ignored.");
        }
        while (this.readChar() != -1 && this._curChar != 62) {
        }
        if (this._curChar == -1) {
            this.error((short)1, "Document type definition terminated at end of document.");
        }
    }

    public Document parseDocument() throws ParseException {
        if (this.isClosed()) {
            throw new IllegalStateException("Parser has been closed and may not be used anymore.");
        }
        try {
            try {
                this._document = DOMFactory.createHTMLDocument();
                int n = this.readTokenContent();
                if (n == 7 && this._tokenText.equals("DOCTYPE")) {
                    this.parseDTDSubset();
                    n = this.readTokenContent();
                }
                this._currentNode = this._document;
                while (this.parseNextNode(n)) {
                    n = this.readTokenContent();
                }
                if (this._nodeText.length() > 0) {
                    this._currentNode.appendChild(this._document.createTextNode(this._nodeText.toString()));
                }
                ((HTMLDocument)this._document).getBody();
            }
            catch (ParseException parseException) {
                throw parseException;
            }
            catch (Exception exception) {
                this.error(exception);
            }
            Object var3_4 = null;
            this.close();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.close();
            throw throwable;
        }
        return this._document;
    }

    protected boolean parseNextNode(int n) throws ParseException, IOException {
        int n2;
        if (n == 8) {
            this.error((short)1, "The sequence '<![' encountered for no good reason.");
            n = 0;
            this._tokenText.insert(0, "<![");
        }
        if (n == 7) {
            this.error((short)1, "The sequence '<!' encountered for no good reason.");
            n = 0;
            this._tokenText.insert(0, "<!");
        }
        if (n == 6) {
            n = 0;
        }
        if (n == 1) {
            n = 0;
            n2 = HTMLDTD.charFromName(this._tokenText.toString());
            if (n2 == -1) {
                this._tokenText.insert(0, '&').append(';');
                this.error((short)1, "Found unresolved entity reference.");
            } else {
                this._tokenText.setLength(1);
                this._tokenText.setCharAt(0, (char)n2);
            }
        }
        if (n == 5 && !this.isMode((short)1) || n == 4 && !this.isMode((short)2)) {
            return true;
        }
        if (n == 0) {
            n2 = 0;
            while (n2 < this._tokenText.length()) {
                char c = this._tokenText.charAt(n2);
                if (this.isSpace(c)) {
                    if (!this._nodeTextSpace) {
                        this._nodeTextSpace = true;
                        this._nodeText.append(' ');
                    }
                } else {
                    this._nodeTextSpace = false;
                    this._nodeText.append(c);
                }
                ++n2;
            }
        } else {
            Node node;
            if (this._nodeText.length() > 0) {
                node = this._document.createTextNode(this._nodeText.toString());
                this._currentNode.appendChild(node);
                this._nodeText.setLength(0);
                this._nodeTextSpace = false;
            }
            if (n == -1) {
                return false;
            }
            if (n == 5) {
                String string = this.slicePITokenText();
                node = this._document.createProcessingInstruction(string, this._tokenText.toString());
                this._currentNode.appendChild(node);
            } else if (n == 4) {
                node = this._document.createComment(this._tokenText.toString());
                this._currentNode.appendChild(node);
            } else if (n == 2) {
                String string;
                boolean bl;
                HTMLElement hTMLElement = (HTMLElement)this._document.createElement(this._tokenText.toUpperCase().toString());
                this._currentNode.appendChild(hTMLElement);
                this.parseAttributes(hTMLElement, false);
                boolean bl2 = bl = HTMLDTD.supportsChildren(hTMLElement) && !HTMLDTD.optionalClosingTag(hTMLElement);
                if (this.isMode((short)32) && (string = hTMLElement.getId()) != null) {
                    if (this._bookmarks == null) {
                        this._bookmarks = XMLBookmarks.of(this._document);
                    }
                    try {
                        this._bookmarks.setUnique(string, hTMLElement);
                    }
                    catch (Exception exception) {
                        this.error((short)1, "Element identifier (ID attribute) is not unique in document element.");
                    }
                }
                if (hTMLElement instanceof HTMLPreElement || hTMLElement instanceof HTMLScriptElement || hTMLElement instanceof HTMLStyleElement) {
                    string = hTMLElement.getTagName();
                    this._tokenText.setLength(0);
                    this.readChar();
                    while (this._curChar != -1) {
                        if (this._curChar == 60) {
                            this.readChar();
                            if (this._curChar == 47) {
                                if (this.canReadName(string)) break;
                                this._curChar = 47;
                            }
                            this.pushBack();
                            this._curChar = 60;
                        }
                        this._tokenText.append((char)this._curChar);
                    }
                    if (this._tokenText.length() > 0 && this._tokenText.charAt(0) == '\n') {
                        this._tokenText.delete(0, 1);
                    }
                    if (this._tokenText.length() > 0 && this._tokenText.charAt(this._tokenText.length() - 1) == '\n') {
                        this._tokenText.setLength(this._tokenText.length() - 1);
                    }
                    hTMLElement.appendChild(this._document.createTextNode(this._tokenText.toString().trim()));
                    while (this._curChar != -1 && this._curChar != 62 && this._curChar != 60) {
                        this.readChar();
                    }
                    if (this._curChar == 60) {
                        this.pushBack();
                    }
                    if (this._curChar != 62) {
                        this.error((short)1, "Element '" + string + "' terminated prematurely.");
                    }
                    return true;
                }
                if (bl) {
                    int n3 = this.getLineNumber();
                    this._currentNode = hTMLElement;
                    n = this.readTokenContent();
                    while (this.parseNextNode(n)) {
                        n = this.readTokenContent();
                        if (n != -1) continue;
                        this.error((short)1, "Element '" + hTMLElement.getTagName() + "' started at line " + n3 + " terminated prematurely at end of file.");
                        break;
                    }
                    ((Element)this._currentNode).normalize();
                    this._currentNode = this._currentNode.getParentNode();
                    this.loseWhitespace(hTMLElement);
                    if (this._orphanClosingTag != null) {
                        this._tokenText.setLength(0);
                        this._tokenText.append(this._orphanClosingTag);
                        return this.closingTag(true);
                    }
                }
            } else if (n == 3) {
                if (this._tokenText.length() == 0) {
                    this.error((short)1, "Encountered closing tag with not tag name.");
                    return true;
                }
                return this.closingTag(false);
            }
        }
        return true;
    }

    public final Node parseNode(Node node) throws ParseException {
        if (node == null) {
            throw new NullPointerException("Argument 'node' is null.");
        }
        if (this.isClosed()) {
            throw new IllegalStateException("Parser has been closed and may not be used anymore.");
        }
        this._document = node.getOwnerDocument();
        try {
            try {
                this._currentNode = node;
                int n = this.readTokenContent();
                while (this.parseNextNode(n)) {
                    n = this.readTokenContent();
                }
                if (this._nodeText.length() > 0) {
                    this._currentNode.appendChild(this._document.createTextNode(this._nodeText.toString()));
                }
            }
            catch (ParseException parseException) {
                throw parseException;
            }
            catch (Exception exception) {
                this.error(exception);
            }
            Object var4_5 = null;
            this.close();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.close();
            throw throwable;
        }
        return node;
    }
}

