/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.util;

import org.openxml.util.FastStringPool;

public class FastString {
    private char[] _chars;
    private int _length;
    private static final FastStringPool _pool = new FastStringPool();

    public FastString() {
        this(16);
    }

    public FastString(int n) {
        this._chars = new char[n + 15 & 0xFFFFFFF0];
    }

    public FastString(String string) {
        this._length = string.length();
        this._chars = new char[this._length + 15 & 0xFFFFFFF0];
        string.getChars(0, this._length, this._chars, 0);
    }

    public FastString(FastString fastString) {
        this._length = fastString._length;
        this._chars = new char[this._length + 15 & 0xFFFFFFF0];
        System.arraycopy(fastString._chars, 0, this._chars, 0, this._length);
    }

    public synchronized FastString append(char c) {
        int n = this._length + 1;
        if (n > this._chars.length) {
            char[] cArray = new char[this.calcSize(n)];
            System.arraycopy(this._chars, 0, cArray, 0, this._length);
            this._chars = cArray;
        }
        this._chars[this._length] = c;
        ++this._length;
        return this;
    }

    public synchronized FastString append(String string) {
        if (string == null) {
            return this;
        }
        int n = string.length();
        int n2 = this._length + n;
        if (n2 > this._chars.length) {
            char[] cArray = new char[this.calcSize(n2)];
            System.arraycopy(this._chars, 0, cArray, 0, this._length);
            this._chars = cArray;
        }
        string.getChars(0, n, this._chars, this._length);
        this._length = n2;
        return this;
    }

    public synchronized FastString append(FastString fastString) {
        FastString fastString2 = fastString;
        synchronized (fastString2) {
            int n = fastString._length;
            int n2 = this._length + n;
            if (n2 > this._chars.length) {
                char[] cArray = new char[this.calcSize(n2)];
                System.arraycopy(this._chars, 0, cArray, 0, this._length);
                this._chars = cArray;
            }
            System.arraycopy(fastString._chars, 0, this._chars, this._length, n);
            this._length = n2;
        }
        return this;
    }

    public synchronized FastString append(char[] cArray, int n, int n2) {
        int n3 = this._length + n2;
        if (n3 > this._chars.length) {
            char[] cArray2 = new char[this.calcSize(n3)];
            System.arraycopy(this._chars, 0, cArray2, 0, this._length);
            this._chars = cArray2;
        }
        System.arraycopy(cArray, n, this._chars, this._length, n2);
        this._length = n3;
        return this;
    }

    private int calcSize(int n) {
        int n2 = (this._chars.length + 1) * 2;
        if (n > n2) {
            n2 = n;
        }
        n = n + 15 & 0xFFFFFFF0;
        return n;
    }

    public synchronized char charAt(int n) {
        if (n < 0 || n >= this._length) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this._chars[n];
    }

    public synchronized FastString delete(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this._length) {
            n2 = this._length;
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        if (n3 > 0) {
            if (n3 < this._length) {
                System.arraycopy(this._chars, n + n3, this._chars, n, this._length - n2);
            }
            this._length -= n3;
        }
        return this;
    }

    public synchronized boolean equals(Object object) {
        return this.equals(object.toString());
    }

    /*
     * Unable to fully structure code
     */
    public synchronized boolean equals(String var1_1) {
        if (var1_1 == null) {
            return false;
        }
        var2_2 = var1_1.length();
        if (var2_2 == this._length) ** GOTO lbl8
        return false;
lbl-1000:
        // 1 sources

        {
            if (var1_1.charAt(var2_2) == this._chars[var2_2]) continue;
            return false;
lbl8:
            // 2 sources

            ** while (var2_2-- > 0)
        }
lbl9:
        // 1 sources

        return true;
    }

    public char[] getCharArray() {
        return this._chars;
    }

    public synchronized void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0 || n >= this._length) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n2 > this._length) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n < n2) {
            System.arraycopy(this._chars, n, cArray, n3, n2 - n);
        } else if (n > n2) {
            throw new StringIndexOutOfBoundsException("begin > end");
        }
    }

    public synchronized FastString insert(int n, char c) {
        int n2 = this._length + 1;
        if (n2 > this._chars.length) {
            char[] cArray = new char[this.calcSize(n2)];
            System.arraycopy(this._chars, 0, cArray, 0, this._length);
            this._chars = cArray;
        }
        System.arraycopy(this._chars, n, this._chars, n + 1, this._length - n);
        this._chars[n] = c;
        this._length = n2;
        return this;
    }

    public synchronized FastString insert(int n, String string) {
        if (string == null) {
            return this;
        }
        if (n < 0 || n > this._chars.length) {
            throw new StringIndexOutOfBoundsException(n);
        }
        int n2 = string.length();
        int n3 = this._length + n2;
        if (n3 > this._chars.length) {
            char[] cArray = new char[this.calcSize(n3)];
            System.arraycopy(this._chars, 0, cArray, 0, this._length);
            this._chars = cArray;
        }
        System.arraycopy(this._chars, n, this._chars, n + n2, this._length - n);
        string.getChars(0, n2, this._chars, n);
        this._length = n3;
        return this;
    }

    public synchronized FastString insert(int n, char[] cArray, int n2, int n3) {
        if (n < 0 || n > this._length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (n2 < 0 || n2 + n3 > cArray.length) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 < 0) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        int n4 = this._length + n3;
        if (n4 > this._chars.length) {
            char[] cArray2 = new char[this.calcSize(n4)];
            System.arraycopy(this._chars, 0, cArray2, 0, this._length);
            this._chars = cArray2;
        }
        System.arraycopy(this._chars, n, this._chars, n + n3, this._length - n);
        System.arraycopy(cArray, n2, this._chars, n, n3);
        this._length = n4;
        return this;
    }

    public int length() {
        return this._length;
    }

    public synchronized FastString replace(int n, int n2, String string) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this._length) {
            n2 = this._length;
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        int n3 = string.length();
        int n4 = this._length + n3 - (n2 - n);
        if (n4 > this._chars.length) {
            char[] cArray = new char[this.calcSize(n4)];
            System.arraycopy(this._chars, 0, cArray, 0, this._length);
            this._chars = cArray;
        }
        System.arraycopy(this._chars, n2, this._chars, n + n3, this._length - n2);
        string.getChars(0, n3, this._chars, n);
        this._length = n4;
        return this;
    }

    public void reset() {
        this._length = 0;
    }

    public synchronized void setCharAt(int n, char c) {
        if (n < 0 || n >= this._length) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this._chars[n] = c;
    }

    public synchronized void setLength(int n) {
        if (n == 0) {
            this.reset();
            return;
        }
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n > this._chars.length) {
            char[] cArray = new char[this.calcSize(n)];
            System.arraycopy(this._chars, 0, cArray, 0, this._length);
        }
        while (this._length < n) {
            this._chars[this._length] = '\u0000';
            ++this._length;
        }
        this._length = n;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized boolean startsWith(String var1_1) {
        if (var1_1 == null) {
            return false;
        }
        var2_2 = var1_1.length();
        if (this._length >= var2_2) ** GOTO lbl8
        return false;
lbl-1000:
        // 1 sources

        {
            if (var1_1.charAt(var2_2) == this._chars[var2_2]) continue;
            return false;
lbl8:
            // 2 sources

            ** while (var2_2-- > 0)
        }
lbl9:
        // 1 sources

        return true;
    }

    public synchronized FastString toLowerCase() {
        int n = 0;
        while (n < this._length) {
            this._chars[this._length] = Character.toLowerCase(this._chars[this._length]);
            ++n;
        }
        return this;
    }

    public synchronized String toString() {
        return _pool.lookup(this._chars, 0, this._length);
    }

    public synchronized String toString(int n, int n2) {
        return _pool.lookup(this._chars, n, n2);
    }

    public synchronized FastString toUpperCase() {
        int n = 0;
        while (n < this._length) {
            this._chars[this._length] = Character.toUpperCase(this._chars[this._length]);
            ++n;
        }
        return this;
    }
}

