/* 
 * Apple // emulator for Linux: Video definitions
 *
 * Copyright 1994 Alexander Jean-Claude Bottema
 * Copyright 1995 Stephen Lee
 * Copyright 1997, 1998 Aaron Culliney
 * Copyright 1998, 1999 Michael Deutschmann
 *
 * This software package is subject to the GNU General Public License
 * version 2 or later (your choice) as published by the Free Software 
 * Foundation.
 *
 * THERE ARE NO WARRANTIES WHATSOEVER. 
 *
 */

#ifndef A2_VIDEO_H
#define A2_VIDEO_H

#define COLOR_BLACK		0

#define COLOR_DARK_RED		35
#define COLOR_MEDIUM_RED	36
#define COLOR_LIGHT_RED		37	/* hgr used */

#define COLOR_DARK_GREEN	38
#define COLOR_MEDIUM_GREEN	39
#define COLOR_LIGHT_GREEN	40	/* hgr used */

#define COLOR_DARK_YELLOW	41
#define COLOR_MEDIUM_YELLOW	42
#define COLOR_LIGHT_YELLOW	43

#define COLOR_DARK_BLUE		44
#define COLOR_MEDIUM_BLUE	45
#define COLOR_LIGHT_BLUE	46	/* hgr used */

#define COLOR_DARK_PURPLE	47
#define COLOR_MEDIUM_PURPLE	48
#define COLOR_LIGHT_PURPLE	49	/* hgr used */

#define COLOR_DARK_CYAN		50
#define COLOR_MEDIUM_CYAN	51
#define COLOR_LIGHT_CYAN	52

#define COLOR_DARK_WHITE	53
#define COLOR_MEDIUM_WHITE	54
#define COLOR_LIGHT_WHITE	55

#define COLOR_FLASHING_BLACK	56
#define COLOR_FLASHING_WHITE	57
#define COLOR_FLASHING_UNGREEN	58
#define COLOR_FLASHING_GREEN	59

/* ----------------------------------
    generic graphics globals
   ---------------------------------- */

unsigned char	*GM;	     /* --- Base address of framebuffer --- */

#ifdef _640x400
unsigned char	expanded_col_hires_even[0x100*16];/* *16 for 640x400 */
unsigned char	expanded_col_hires_odd[0x100*16];/* ditto */
unsigned char	expanded_col8_hires_even[0x100*8];
unsigned char	expanded_col8_hires_odd[0x100*8];
#else
unsigned char	expanded_col_hires_even[0x100*8];
unsigned char	expanded_col_hires_odd[0x100*8];
#endif

unsigned char	dhires_colors1[256];
unsigned char	dhires_colors2[256];

int crnt_visual_svga_page;	/* Current visual page */
int crnt_active_svga_page;	/* Current active page */
int oldpage;
int oldscreen;

void c_initialize_video();
void c_shutdown_video();
void c_clear_video();

void c_keyboard_on();
void c_keyboard_off();
int  c_mygetch(int block);
void c_flash_cursor(int flash_cnt);
void c_video_refresh();

/* -------------------------------------------------------------------------
 * c_setpage(p): sets the current active graphics page.  This does not have to
 * 	be the same as the current visual (display) page.  Graphics routines
 * 	will write to the active page.  This is called to reset the active
 * 	page each time a byte is written to apple ][ graphics memory that is
 * 	not the active page.
 *
 * c_setscreen(p): sets the current visual page to page p (displays page p).
 *
 * This is called when PAGE2, 80STORE switches are changed.
 * p: 0, 1
 * ------------------------------------------------------------------------- */
void c_setpage(int p);
void c_setscreen(int p);

#endif
