/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef _BANK_ROM_H_
#define _BANK_ROM_H_

class StreamHandle;
class SessionFile;

const uae_u32	kROMMemoryStart = 0x10C00000;

class ROMBank
{
	public:
		static void				Initialize		(StreamHandle& hROM);
		static void				Reset			(void);
		static void				Save			(SessionFile&);
		static void				Load			(SessionFile&);
		static void				Dispose			(void);

		static void				SetBankHandlers	(void);

		static uae_u32			GetLong			(uaecptr iAddress);
		static uae_u32			GetWord			(uaecptr iAddress);
		static uae_u32			GetByte			(uaecptr iAddress);
		static void				SetLong			(uaecptr iAddress, uae_u32 iLongValue);
		static void				SetWord			(uaecptr iAddress, uae_u32 iWordValue);
		static void				SetByte			(uaecptr iAddress, uae_u32 iByteValue);
		static int				ValidAddress	(uaecptr iAddress, uae_u32 iSize);
		static uae_u8*			GetRealAddress	(uaecptr iAddress);
		static uae_u8*			GetMetaAddress	(uaecptr iAddress);
		static void				AddOpcodeCycles	(void);

		static uaecptr			GetMemoryStart	(void) { return kROMMemoryStart; }
		static int				IsPCInRAM		(void) { return m68k_getpc () < GetMemoryStart (); }
		static int				IsPCInROM		(void) { return m68k_getpc () >= GetMemoryStart (); }

	private:
		static void				InvalidAccess	(uaecptr iAddress, long size, Bool forRead);
		static void				LoadROM			(StreamHandle& hROM);
};


class FlashBank
{
	public:
		static void				Initialize		(void);
		static void				Reset			(void);
		static void				Save			(SessionFile&);
		static void				Load			(SessionFile&);
		static void				Dispose			(void);

		static uae_u32			GetLong			(uaecptr iAddress);
		static uae_u32			GetWord			(uaecptr iAddress);
		static uae_u32			GetByte			(uaecptr iAddress);
		static void				SetLong			(uaecptr iAddress, uae_u32 iLongValue);
		static void				SetWord			(uaecptr iAddress, uae_u32 iWordValue);
		static void				SetByte			(uaecptr iAddress, uae_u32 iByteValue);
		static int				ValidAddress	(uaecptr iAddress, uae_u32 iSize);
		static uae_u8*			GetRealAddress	(uaecptr iAddress);
		static uae_u8*			GetMetaAddress	(uaecptr iAddress);
		static void				AddOpcodeCycles	(void);

		static uaecptr			GetMemoryStart	(void) { return kROMMemoryStart; }
};


#endif /* _BANK_ROM_H_ */

