/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef STREAMHANDLE_H_
#define STREAMHANDLE_H_

#include "ErrorHandling.h"		// ErrCode

class FileReference;

enum SeekMode
{
	kSeekSet,
	kSeekCur,
	kSeekEnd
};

class StreamHandle
{
	public:
							StreamHandle	(void);
		virtual				~StreamHandle	(void);

		virtual void		SetPos			(uae_s32 offset, SeekMode) = 0;
		virtual uae_s32		GetPos			(void) = 0;

		virtual uae_s32		GetLength		(void) = 0;

		virtual void		Read			(uae_s32 length, void* buffer) = 0;
		virtual void		Write			(uae_s32 length, const void* buffer);

		Bool				IsFile			(void) { return false; }
		Bool				GetFileRef		(FileReference& f);

	protected:
		void				Throw			(ErrCode);
};


class BufferHandle : public StreamHandle
{
	public:
							BufferHandle	(void* data,
											 uae_s32 size);
		virtual				~BufferHandle	(void);

		virtual void		SetPos			(long offset, SeekMode);
		virtual uae_s32		GetPos			(void) { return fPos; }

		virtual uae_s32		GetLength		(void) { return fSize; }

		virtual void		Read			(uae_s32 length, void* buffer);

	private:

		// Copy constructor disabled
							BufferHandle	(const BufferHandle&);

		char*				fData;
		uae_s32				fSize;
		uae_s32				fPos;
};



#endif	// STREAMHANDLE_H_


