/* $Revision: 1.2 $ */
/*
 * "gpgp" Gnome/GTK Front for PGP
 * Copyright (C) 1998  Max Valianskiy
 * Copyright (C) 1999 tftp@netscape.net
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 */
#include "../config.h"
#include "../version.h"

#include <gnome.h>

#include "gpgp.h"

enum 
{
   LAST_SIGNAL
};

static void gnome_pgp_lib_properties_class_init(GnomePgpLibPropertiesClass *klass);
static void gnome_pgp_lib_properties_init(GnomePgpLibProperties *ttt);

static void change_cb(GtkWidget* widget, GnomePropertyBox* data);

static gint gnome_pgp_lib_properties_signals[LAST_SIGNAL] = { 0 };

guint gnome_pgp_lib_properties_get_type()
{
    static guint gnome_pgp_lib_properties_type = 0;

    if (!gnome_pgp_lib_properties_type)
    {
        GtkTypeInfo gnome_pgp_lib_properties_info =
        {
            "GnomePgpLibProperties",
            sizeof (GnomePgpLibProperties),
            sizeof (GnomePgpLibPropertiesClass),
            (GtkClassInitFunc) gnome_pgp_lib_properties_class_init,
            (GtkObjectInitFunc) gnome_pgp_lib_properties_init,
            (GtkArgSetFunc) NULL,
            (GtkArgGetFunc) NULL
        };
        gnome_pgp_lib_properties_type = gtk_type_unique(
            gnome_property_box_get_type(),
            &gnome_pgp_lib_properties_info);
    }
    return gnome_pgp_lib_properties_type;
}

static void gnome_pgp_lib_properties_class_init(
    GnomePgpLibPropertiesClass *class)
{
    GtkObjectClass *object_class;

    object_class = (GtkObjectClass*) class;
    gtk_object_class_add_signals(
        object_class, gnome_pgp_lib_properties_signals, LAST_SIGNAL);
}

static void gnome_pgp_lib_properties_init(GnomePgpLibProperties *page)
{
    GtkWidget* files_box;
    GtkWidget* prompt_box;
    GtkWidget* trust_box;
    GtkWidget *trust_box1, *trust_box2;
    GtkWidget* options_box;
    GtkWidget *label1, *label2;
    char       buf[1000];
  
    gtk_window_set_title(GTK_WINDOW(page),_("GnomePGP Global Properties"));

    /* Files and Path */
    files_box = gtk_vbox_new(FALSE, 0);
    gtk_notebook_append_page(
        GTK_NOTEBOOK(GNOME_PROPERTY_BOX(page)->notebook),
        files_box,
        gtk_label_new(_("Files and path")));
 
    /* pgppath */
    page->pgppath = GNOME_FILE_ENTRY(
        gnome_file_entry_new("pgppath",
                             _("Select GPG Home Directory")));
    gtk_box_pack_start(
        GTK_BOX(files_box),
        GTK_WIDGET(page->pgppath),
        FALSE,
        TRUE,
        GNOME_PAD_SMALL);
    gtk_entry_set_text(
        GTK_ENTRY(gnome_file_entry_gtk_entry(page->pgppath)),
        gpgp_options.pgppath);
    gtk_signal_connect(
        GTK_OBJECT(gnome_file_entry_gtk_entry(page->pgppath)),
        "changed",
        GTK_SIGNAL_FUNC(change_cb),
        GNOME_PROPERTY_BOX(page));

    /* defsec */
    page->defsec = GNOME_FILE_ENTRY(
        gnome_file_entry_new("Secret Keyring",
                             _("Select Default Secret Keyring")));
    gtk_box_pack_start(
        GTK_BOX(files_box),
        GTK_WIDGET(page->defsec),
        FALSE,
        TRUE,
        GNOME_PAD_SMALL);
    gtk_entry_set_text(
        GTK_ENTRY(gnome_file_entry_gtk_entry(page->defsec)),
        gpgp_options.defsec);
    gtk_signal_connect(
        GTK_OBJECT(gnome_file_entry_gtk_entry(page->defsec)),
        "changed",
        GTK_SIGNAL_FUNC(change_cb),
        GNOME_PROPERTY_BOX(page));
 
    /* defpub */
    page->defpub = GNOME_FILE_ENTRY(
        gnome_file_entry_new("Public Keyring",
                             _("Select Default Public Keyring")));
    gtk_box_pack_start(
        GTK_BOX(files_box),
        GTK_WIDGET(page->defpub),
        FALSE,
        TRUE,
        GNOME_PAD_SMALL);
    gtk_entry_set_text(
        GTK_ENTRY(gnome_file_entry_gtk_entry(page->defpub)),
        gpgp_options.defpub);
    gtk_signal_connect(
        GTK_OBJECT(gnome_file_entry_gtk_entry(page->defpub)),
        "changed",
        GTK_SIGNAL_FUNC(change_cb),
        GNOME_PROPERTY_BOX(page));
 
    /* Prompts */
    prompt_box = gtk_vbox_new(FALSE, 0);
    gtk_notebook_append_page(
        GTK_NOTEBOOK(GNOME_PROPERTY_BOX(page)->notebook),
        prompt_box,
        gtk_label_new(_("Confirmation")));

    page->sign_verbose = GTK_CHECK_BUTTON(
        gtk_check_button_new_with_label(_("Show Ok dialog in Sign widget")));
    gtk_box_pack_start(
        GTK_BOX(prompt_box),
        GTK_WIDGET(page->sign_verbose),
        FALSE,
        TRUE,
        GNOME_PAD_SMALL);
    gtk_toggle_button_set_state(
        GTK_TOGGLE_BUTTON(page->sign_verbose),
        gpgp_options.sign_verbose);
    gtk_signal_connect(
        GTK_OBJECT(page->sign_verbose),
        "toggled",
        GTK_SIGNAL_FUNC(change_cb),
        GNOME_PROPERTY_BOX(page));

    page->unsign_verbose = GTK_CHECK_BUTTON(
        gtk_check_button_new_with_label(_("Show Ok dialog in UnSign widget")));
    gtk_box_pack_start(
        GTK_BOX(prompt_box),
        GTK_WIDGET(page->unsign_verbose),
        FALSE,
        TRUE,
        GNOME_PAD_SMALL);
    gtk_toggle_button_set_state(
        GTK_TOGGLE_BUTTON(page->unsign_verbose),
        gpgp_options.unsign_verbose);
    gtk_signal_connect(
        GTK_OBJECT(page->unsign_verbose),
        "toggled",
        GTK_SIGNAL_FUNC(change_cb),
        GNOME_PROPERTY_BOX(page));
 
    /* Trust */  
    trust_box = gtk_vbox_new(FALSE, 0);
    gtk_notebook_append_page(
        GTK_NOTEBOOK(GNOME_PROPERTY_BOX(page)->notebook),
        trust_box,
        gtk_label_new(_("Trust")));

    trust_box1 = gtk_hbox_new(FALSE,0);
    gtk_box_pack_start(
        GTK_BOX(trust_box),
        trust_box1,
        FALSE,
        TRUE,
        GNOME_PAD_SMALL);
    trust_box2 = gtk_hbox_new(FALSE,0);
    gtk_box_pack_start(
        GTK_BOX(trust_box),
        trust_box2,
        FALSE,
        TRUE,
        GNOME_PAD_SMALL);

    label1 = gtk_label_new(_("Completes Need"));
    gtk_box_pack_start(
        GTK_BOX(trust_box1),
        label1,
        FALSE,
        TRUE,
        GNOME_PAD_SMALL);
 
    label2 = gtk_label_new(_("Marginals Need"));
    gtk_box_pack_start(
        GTK_BOX(trust_box2),
        label2,
        FALSE,
        TRUE,
        GNOME_PAD_SMALL);
 
    g_snprintf(buf,sizeof(buf),"%d", gpgp_options.completes_need);
    page->completes_need=GNOME_ENTRY(gnome_entry_new("completes_need"));
    gtk_box_pack_start(
        GTK_BOX(trust_box1),
        GTK_WIDGET(page->completes_need),
        FALSE,
        TRUE,
        GNOME_PAD_SMALL);
    gtk_entry_set_text(
        GTK_ENTRY(gnome_entry_gtk_entry(page->completes_need)),
        g_strdup(buf)); 
    gtk_signal_connect(
        GTK_OBJECT(gnome_entry_gtk_entry(page->completes_need)),
        "changed",
        GTK_SIGNAL_FUNC(change_cb),
        GNOME_PROPERTY_BOX(page));

    g_snprintf(buf,sizeof(buf), "%d", gpgp_options.marginals_need);
    page->marginals_need=GNOME_ENTRY(gnome_entry_new("marginals_need"));
    gtk_box_pack_start(
        GTK_BOX(trust_box2),
        GTK_WIDGET(page->marginals_need),
        FALSE,
        TRUE,
        GNOME_PAD_SMALL);
    gtk_entry_set_text(
        GTK_ENTRY(gnome_entry_gtk_entry(page->marginals_need)),
        g_strdup(buf)); 
    gtk_signal_connect(
        GTK_OBJECT(gnome_entry_gtk_entry(page->marginals_need)),
        "changed",
        GTK_SIGNAL_FUNC(change_cb),
        GNOME_PROPERTY_BOX(page));

    /* Options */  
    options_box = gtk_vbox_new(FALSE, 0);
    gtk_notebook_append_page(
        GTK_NOTEBOOK(GNOME_PROPERTY_BOX(page)->notebook),
        options_box,
        gtk_label_new(_("Options")));

    page->rfc1991=GTK_CHECK_BUTTON(
        gtk_check_button_new_with_label(_("RFC1991 mode")));
    gtk_box_pack_start(
        GTK_BOX(options_box),
        GTK_WIDGET(page->rfc1991),
        FALSE,
        TRUE,
        GNOME_PAD_SMALL);
    gtk_toggle_button_set_state(
        GTK_TOGGLE_BUTTON(page->rfc1991),
        gpgp_options.rfc1991);
    gtk_signal_connect(
        GTK_OBJECT(page->rfc1991),
        "toggled",
        GTK_SIGNAL_FUNC(change_cb),
        GNOME_PROPERTY_BOX(page));
 
    page->comment=GTK_CHECK_BUTTON(
        gtk_check_button_new_with_label(_("Add Comment")));
    gtk_box_pack_start(
        GTK_BOX(options_box),
        GTK_WIDGET(page->comment),
        FALSE,
        TRUE,
        GNOME_PAD_SMALL);
    gtk_toggle_button_set_state(
        GTK_TOGGLE_BUTTON(page->comment),
        gpgp_options.comment);
    gtk_signal_connect(
        GTK_OBJECT(page->comment),
        "toggled",
        GTK_SIGNAL_FUNC(change_cb),
        GNOME_PROPERTY_BOX(page));
  
    gtk_widget_show_all(GNOME_PROPERTY_BOX(page)->notebook);
}

GtkWidget *gnome_pgp_lib_properties_new (void)
{
    GnomePgpLibProperties* page;

    page = gtk_type_new (gnome_pgp_lib_properties_get_type ());
    return GTK_WIDGET (page);
}

static void change_cb(GtkWidget* widget, GnomePropertyBox* data)
{
    /* This is hack to GTK,
     * because "changed" event sends on destroy 
     * always
     */
    if (GTK_NOTEBOOK(data->notebook)->cur_page)
        gnome_property_box_changed(data);
}
