/*
 * This simple program tries to lock a file the same way dpkg (and
 * apt) do. If it succeeds, it drops the lock and returns 0. If it fails,
 * it returns > 0.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/file.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

static int methlockfd;

int main (int argc, char **argv) {
  	struct flock fl;
  	if (argc < 2) {
	  	fprintf(stderr, "Must specify lock file to check.\n");
	  	exit(100);
	}
  	methlockfd = open(argv[1], O_RDWR|O_CREAT|O_TRUNC, 0660);
  	if (methlockfd == -1) {
	  	exit(2);
	}
  	fl.l_type= F_WRLCK;
  	fl.l_whence= SEEK_SET;
  	fl.l_start= 0;
  	fl.l_len= 0;
	if (fcntl(methlockfd,F_SETLK,&fl) == -1) {
	  	exit(1);
	}
  	exit (0);
}
