
#include <std.h>
#include <ops.h>

#ifdef HAVE_LIBGPM
#include <gpm.h>
#endif

#include <func/apt.h>
#include <func/dependency.h>
#include <func/config.h>
#include <func/pkgchecks.h>

#include <interface/coreui.h>
#include <interface/acquire.h>
#include <interface/formatting.h>
#include <interface/sortui.h>
#include <interface/dialogs.h>
#include <interface/menu.h>

#include <list/screens.h>
#include <list/filters.h>
#include <list/colors.h>

#include "keys.h"

KeyHandler::List DefaultKeys::Bindings[] =
{
	{
	-1, NULL, NULL, "$5#Toggles$!"}
	,
	{
	'\t', DefaultKeys::depend_toggle, "Tab", "Show package dependencies"}
	,
	{
	'd', DefaultKeys::descwin_toggle, "d", "Show package description"}
	,
	{
	'V', DefaultKeys::viewmode_toggle, "V", "Toggle verbose view mode"}
	,
	{
	's', DefaultKeys::sort_method, "s", "Change list sort method(s)"}
	,
	{
	'/', DefaultKeys::search, "/", "Search through the list"}
	,
	{
	18, DefaultKeys::reset_markers, "Ctrl-R", "Reset items marked by search"}
	,
	{
	'n', ui_seek_nextmatched, "n", "Move to next search match"}
	,
	{
	-1, NULL, NULL, "$5#Filters$!"}
	,
	{
	'f', filter_add_single, "f", "Add new filter"}
	,
	{
	'r', filter_revoke_all, "r", "Revoke all filters"}
	,
	{
	'l', filter_display_all, "l", "Display filter list"}
	,
	{
	'v', filter_invert, "v", "Invert filter polarity"}
	,
	{
	-1, NULL, NULL, "$5#Modifiers$!"}
	,
	{
	'+', DefaultKeys::pkg_install, "+", "Mark for install/upgrade"}
	,
	{
	' ', DefaultKeys::pkg_install, "Space", "Mark for install/upgrade"}
	,
	{
	'-', DefaultKeys::pkg_remove, "-", "Mark for deletion"}
	,
	{
	'_', DefaultKeys::pkg_purge, "_", "Mark for purgation (deletes config files)"}
	,
	{
	'U', DefaultKeys::dist_upgrade, "U", "Upgrade all old packages"}
	,
	{
	-1, NULL, NULL, "$5#Functions$!"}
	,
	{
	'c', DefaultKeys::complete_pending, "c", "Complete pending install/removals"}
	,
	{
	KEY_BACKSPACE, DefaultKeys::complete_pending, "Backspace", "Complete pending install/removals"}
	,
	{
	'u', DefaultKeys::update_lists, "u", "Update available package lists"}
	,
	{
	'R', DefaultKeys::reread_cache, "R", "Reinitialize the apt cache"}
	,
	{
	-1, NULL, NULL, "$5#Movement$!"}
	,
	{
	KEY_UP, ui_arrow_up, "Up", "Move to the previous package"}
	,
	{
	KEY_DOWN, ui_arrow_down, "Down", "Move to the next package"}
	,
	{
	'k', ui_arrow_up, "k", "Move to the previous package"}
	,
	{
	'j', ui_arrow_down, "j", "Move to the next package"}
	,
	{
	'^', ui_seek_start, "^", "Move to the start of the list"}
	,
	{
	'g', ui_seek_start, "g", "Move to the start of the list"}
	,
	{
	'$', ui_seek_end, "$$", " Move to the end of the list"}
	,
	{
	'G', ui_seek_end, "G", "Move to the end of the list"}
	,
	{
	KEY_HOME, ui_seek_start, "Home", "Move to the list start"}
	,
	{
	KEY_END, ui_seek_end, "End", "Move to the list end"}
	,
	{
	2, ui_page_up, "CTRL-F", "Move up one screens length"}
	,
	{
	6, ui_page_down, "CTRL-B", "Move down one screens length"}
	,
	{
	KEY_PPAGE, ui_page_up, "PageUp", "Move up one screens length"}
	,
	{
	KEY_NPAGE, ui_page_down, "PageDown", "Move down one screens length"}
	,
	{
	KEY_LEFT, DefaultKeys::dscroll_left, "Left", "Scroll description left (Verbose only)"}
	,
	{
	KEY_RIGHT, DefaultKeys::dscroll_right, "Right", "Scroll description right (Verbose only)"}
	,
	{
	'[', ui_scroll_descwin_up, "[", "Scroll package description UP"}
	,
	{
	']', ui_scroll_descwin_down, "]", "Scroll package description DOWN"}
	,
	{
	'<', ui_divider_prev, "<", "Move to the PREVIOUS package divider"}
	,
	{
	'>', ui_divider_next, ">", "Move to the NEXT package divider"}
	,
	{
	-1, NULL, NULL, "$5#Explanatory$!"}
	,
	{
	'q', DefaultKeys::quit, "q", "Quit the program"}
	,
	{
	'?', HelpDialog, "?", "Display this help screen"}
	,
	{
	'h', HelpDialog, "h", "Display this help screen"}
	,
	{
	0, NULL, NULL, NULL}
};

KeyHandler::List RestrictedKeys::Bindings[] =
{
	{
	-1, NULL, NULL, "$5#Explanatory$!"}
	,
	{
	'?', HelpDialog, "?", "Display this help screen"}
	,
	{
	'h', HelpDialog, "h", "Display this help screen"}
	,
	{
	'q', RestrictedKeys::abort, "q", "Abort package acuisition"}
	,
	{
	'c', RestrictedKeys::complete, "c", "Continue with package acquisition"}
	,
	{
	-1, NULL, NULL, "$5#Toggles$!"}
	,
	{
	'\n', DefaultKeys::depend_toggle, "Enter", "Show package dependencies"}
	,
	{
	'd', DefaultKeys::descwin_toggle, "d", "Show package description"}
	,
	{
	'V', DefaultKeys::viewmode_toggle, "V", "Toggle verbose view mode"}
	,
	{
	's', DefaultKeys::sort_method, "s", "Change list sort method(s)"}
	,
	{
	'/', DefaultKeys::search, "/", "Search through the list"}
	,
	{
	18, DefaultKeys::reset_markers, "Ctrl-R", "Reset items marked by search"}
	,
	{
	'n', ui_seek_nextmatched, "n", "Move to next search match"}
	,
	{
	-1, NULL, NULL, "$5#Filters$!"}
	,
	{
	'f', filter_add_single, "f", "Add new filter"}
	,
	{
	'r', filter_revoke_all, "r", "Revoke all filters"}
	,
	{
	'l', filter_display_all, "l", "Display filter list"}
	,
	{
	'v', filter_invert, "v", "Invert filter polarity"}
	,
	{
	-1, NULL, NULL, "$5#Movement$!"}
	,
	{
	KEY_UP, ui_arrow_up, "Up", "Move to the previous package"}
	,
	{
	KEY_DOWN, ui_arrow_down, "Down", "Move to the next package"}
	,
	{
	'k', ui_arrow_up, "k", "Move to the previous package"}
	,
	{
	'j', ui_arrow_down, "j", "Move to the next package"}
	,
	{
	'^', ui_seek_start, "^", "Move to the start of the list"}
	,
	{
	'g', ui_seek_start, "g", "Move to the start of the list"}
	,
	{
	'$', ui_seek_end, "$$", " Move to the end of the list"}
	,
	{
	'G', ui_seek_end, "G", "Move to the end of the list"}
	,
	{
	KEY_HOME, ui_seek_start, "Home", "Move to the list start"}
	,
	{
	KEY_END, ui_seek_end, "End", "Move to the list end"}
	,
	{
	2, ui_page_up, "CTRL-F", "Move up one screens length"}
	,
	{
	6, ui_page_down, "CTRL-B", "Move down one screens length"}
	,
	{
	KEY_PPAGE, ui_page_up, "PageUp", "Move up one screens length"}
	,
	{
	KEY_NPAGE, ui_page_down, "PageDown", "Move down one screens length"}
	,
	{
	KEY_LEFT, DefaultKeys::dscroll_left, "Left", "Scroll description left (Verbose only)"}
	,
	{
	KEY_RIGHT, DefaultKeys::dscroll_right, "Right", "Scroll description right (Verbose only)"}
	,
	{
	'[', ui_scroll_descwin_up, "[", "Scroll package description UP"}
	,
	{
	']', ui_scroll_descwin_down, "]", "Scroll package description DOWN"}
	,
	{
	0, NULL, NULL, NULL}
};

bool KeyHandler::inputmgr()
{
#ifdef HAVE_LIBGPM
	return handlemgr(Gpm_Wgetch(wmain));
#else
	return handlemgr(wgetch(wmain));
#endif
}

bool KeyHandler::handlemgr(int Keypress)
{
	List *p;

	for (p = klptr; p->key != 0; p++)
	{
		if (p->handlefunc == NULL)
			continue;

		if (Keypress == p->key)
		{
			p->handlefunc();
			break;
		}
	}

	// For the menu

	switch (Keypress)
	{
		// Operation
	case 'O':
		{
			MenuDrop d(MenuDrop::M_Functions);
			ui_refresh_current();
		}
		break;
		// Movement
	case 'M':
		{
			MenuDrop d(MenuDrop::M_Movement);
			ui_refresh_current();
		}
		break;
		// Toggles
	case 'T':
		{
			MenuDrop d(MenuDrop::M_Toggles);
			ui_refresh_current();
		}
		break;
		// Alter
	case 'A':
		{
			MenuDrop d(MenuDrop::M_Modifiers);
			ui_refresh_current();
		}
		break;
		// Filters
	case 'F':
		{
			MenuDrop d(MenuDrop::M_Filters);
			ui_refresh_current();
		}
		break;
		// Sorting
	case 'S':
		{
			MenuDrop d(MenuDrop::M_Sorting);
			ui_refresh_current();
		}
		break;
	}

	return true;
}

// ...

void DefaultKeys::dscroll_left()
{
	if (screen->mode == ScreenList::Verbose)
	{
		if (screen->scroll > 0)
			screen->scroll -= 4;

		ui_redraw_main();
		paint_top();
		paint_description();
	}

	return;
}

void DefaultKeys::dscroll_right()
{
	if (screen->mode == ScreenList::Verbose)
	{
		screen->scroll += 4;
		ui_redraw_main();
		paint_top();
		paint_description();
	}

	return;
}

void DefaultKeys::viewmode_toggle()
{
	if (screen->mode == ScreenList::Normal)
	{
		screen->mode = ScreenList::Verbose;
		set_config_string("view", "verbose");
	}
	else
	{
		screen->mode = ScreenList::Normal;
		set_config_string("view", "normal");
	}

	ui_redraw_current();

	return;
}

/*
 * Wrapper for the online search option: Search through the current
 * screen's package list.
 *
 *  The user can enter a blank string to repeat the last search.
 */
void DefaultKeys::search()
{
	char *buf = (char *) malloc(COLS);
	unsigned long options = 0;

	ui_search_entry(&buf, &options);

	if (*buf)
	{
		screen->Packages->ClearFlag(PackageList::Matched);
		screen->Packages->Locate(buf, options);
		ui_seek_nextmatched();
		ui_redraw_current();
	}

	free(buf);

	return;
}

void DefaultKeys::descwin_toggle()
{
	if (wdesc == NULL)
	{
		ui_desc_window_show();
		paint_description_top();
		paint_description();
		set_config_string("description", "1");
	}
	else
	{
		ui_desc_window_hide();
		set_config_string("description", "0");
	}

	ui_redraw_main();

	return;
}

void DefaultKeys::depend_toggle()
{
	if (screen->Cursor->type != PackageList::Pkg)
	{
/*		werase(wtop);
		wprintw(wtop, "Name='%s' Section='%s' Priority='%s'", screen->Cursor->pkg.Name(), screen->Cursor->pkg.Section(),
		(*Cache)[screen->Cursor->pkg].CandidateVerIter(*Cache).PriorityType());
		wrefresh(wtop);*/
		return;
	}

	bool expanded = false;

	for (PackageList::Package * p = screen->Cursor->next; p != NULL; p = p->next)
		if (p->p_parent == screen->Cursor)
			expanded = true;

	if (expanded == true)
		depend_destruct(screen->Cursor);
	else
		depend_expand(screen->Cursor->pkg, screen->Cursor);

	screen.boundreset(screen.Current());
	ui_redraw_main();

	return;
}

void DefaultKeys::sort_method()
{
	sort_select_method();

	return;
}

void DefaultKeys::reread_cache()
{
	global_cache_reinit();

	ui_redraw_current();

	return;
}

void DefaultKeys::update_lists()
{
	if (getuid() != 0)
	{
		ui_dialog(Pair(COLOR_YELLOW, COLOR_BLUE) | A_BOLD, "Error", "\nRoot privileges are required\n");
		ui_redraw_current();
		return;
	}

	pkgAcquireInterface *Fetcher = new pkgAcquireInterface;
	Fetcher->AcquireUpdate();
	delete Fetcher;

	curs_set(0);

	ui_redraw_current();

	return;
}

void DefaultKeys::dist_upgrade()
{
	if (pkgAllUpgrade(*Cache) == false)
	{
		capt_show_broken(*Cache);
		redrawwin(wmain);
		redrawwin(wstat);
		redrawwin(wtop);
		return;
	}
	ui_redraw_current();

	return;
}

void DefaultKeys::pkg_remove()
{
	if (screen->Cursor->type != PackageList::Pkg)
		return;

	pkgCache::PkgIterator I = screen->Cursor->pkg;

	_config->Set("APT::Console::Purge", "off");

	unsigned Expected = 0;

	if (I.CurrentVer().end() == false)
	{
		if ((*Cache)[I].Delete() == true)
			Cache->MarkKeep(I);
		else
			TryToInstall(I, *Cache, *Fix, true, true, Expected, true);
	}

	ui_arrow_down();
	ui_redraw_current();

	paint_status();

	return;
}

void DefaultKeys::pkg_purge()
{
	if (screen->Cursor->type != PackageList::Pkg)
		return;

	pkgCache::PkgIterator I = screen->Cursor->pkg;

	_config->Set("APT::Console::Purge", "on");

	unsigned Expected = 0;

	if (I.CurrentVer().end() == false)
	{
		if ((*Cache)[I].Delete() == true)
			Cache->MarkKeep(I);
		else
			TryToInstall(I, *Cache, *Fix, true, true, Expected, true);
	}

	ui_arrow_down();
	ui_redraw_current();

	paint_status();

	return;
}

void DefaultKeys::pkg_install()
{
	if (screen->Cursor->type != PackageList::Pkg)
		return;

	pkgCache::PkgIterator I = screen->Cursor->pkg;

	unsigned Expected = 0;

	if (I.CurrentVer().end() == true || (*Cache)[I].Status == 1)
	{
		if ((*Cache)[I].Install() == true)
			Cache->MarkKeep(I);
		else
			TryToInstall(I, *Cache, *Fix, false, true, Expected, true);
	}

	ui_arrow_down();
	ui_redraw_current();

	return;
}

void DefaultKeys::complete_pending()
{
	if (Cache->DelCount() == 0 && Cache->InstCount() == 0 && Cache->BadCount() == 0)
		return;

	if (getuid() != 0)
	{
		ui_dialog(Pair(COLOR_YELLOW, COLOR_BLUE) | A_BOLD, "Error", "\nRoot privileges are required\n");
		ui_redraw_current();
		return;
	}

	screen.markstat = screen.add(ScreenList::noPkgInit);
	screen->Packages = new PackageList(PackageList::ModPkgs);
	screen.boundreset(screen.Current());

	ui_redraw_current();

	// Let them fiddle with the view
	delete screen->kdriver;
	screen->kdriver = new KeyHandler(RestrictedKeys::Bindings);

	curs_set(0);
	ui_redraw_current();

	return;
}

void DefaultKeys::quit()
{
	capt_clean_exit();
	exit(0);
}

void DefaultKeys::reset_markers()
{
	screen->Packages->ClearFlag(PackageList::Matched);
	ui_redraw_current();

	return;
}

void DefaultKeys::changed_packages()
{
	screen.markstat = screen.add(ScreenList::noPkgInit);
	screen->Packages = new PackageList(PackageList::ModPkgs);
	screen.boundreset(screen.Current());

	ui_redraw_current();

	return;
}

// ... //

void RestrictedKeys::complete()
{
	pkgAcquireInterface *Fetcher = new pkgAcquireInterface;
	Fetcher->AcquireRun();
	delete Fetcher;

	screen = screen.markstat->prev;
	screen.remove(screen.markstat);
	screen.markstat = NULL;

	curs_set(0);

	ui_redraw_current();
}

void RestrictedKeys::abort()
{
	screen.remove(screen.markstat);
	screen.markstat = NULL;
	screen = screen.Head();

	ui_redraw_current();

	return;
}
