
#ifndef _sort_h
#define _sort_h

class sortorderlist
{
      public:
	class SortIterator;
	friend SortIterator;

	struct Node;

	// Define the different sort methods that can be added to this methodlist
	enum method_t
	{ None = 0, Section = 1, PkgName = 2, Priority = 3, Status = 4, Size = 5, Instsize = 6 };

	// length of the list
	inline int Length()
	{
		return nodecount;
	};

	// List functions
	void Push(method_t);
	void Insert(SortIterator &, method_t);
	void Pop();
	void remove(SortIterator &);
	void Flush();

	static int qsort_handler(const void *, const void *);
	int prioritycmp(const char *, const char *);

	// Inquisitory functions
	int DividerCount();
	int FindIncrement(enum method_t);
	bool Exists(enum method_t);

	void reorderseqids();
	void commit_to_config();
	void copy_from_config();

	// Iterator thingies
	SortIterator ListBegin();
	SortIterator ListEnd();
	SortIterator *ListFind(method_t);

	// con/destructers
	 sortorderlist();
	~sortorderlist();

      protected:
	unsigned int nodecount;
	Node *Head;
	Node *Tail;
};

struct sortorderlist::Node
{
	unsigned int seqid;
	enum sortorderlist::method_t thismethod;

	struct sortorderlist::Node * next;
};

class sortorderlist::SortIterator
{
      public:
	friend sortorderlist;

	inline void operator = (SortIterator B) { Pos = B.Pos;
	};
	void operator++ (int)
	{
		Pos = Pos->next;
	};
	inline void operator++ ()
	{
		operator++ (0);
	};

	inline bool operator == (SortIterator & B) { return Pos == B.Pos;
	};
	inline bool operator != (SortIterator & B)
	{
		return Pos != B.Pos;
	};

	inline bool end()
	{
		return Pos == NULL;
	};

	inline enum method_t method()
	{
		return Pos->thismethod;
	};
	inline unsigned int seq()
	{
		return Pos->seqid;
	};

	inline SortIterator(sortorderlist & Owner)
	{
		Pos = Owner.Head;
	};
	inline SortIterator(Node * NewPos)
	{
		Pos = NewPos;
	};
	inline SortIterator()
	{
	};

      protected:
	Node * Pos;
};

inline sortorderlist::SortIterator sortorderlist::ListBegin()
{
	return SortIterator(Head);
}

inline sortorderlist::SortIterator sortorderlist::ListEnd()
{
	return SortIterator(Tail);
}

#endif
