/*

    Message Box Composite Widget (currently included in various software)
    Copyright (C) 1999 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "msgbox.h"

#include "bong.xpm"
#include "exclam.xpm"
#include "info.xpm"
#include "question.xpm"

/* globals */
struct yesnocancel_data ync;
struct ok_data okd;

gchar ** mb_icons[5]={NULL,bong_xpm,info_xpm,exclam_xpm,question_xpm};

gint message_box_yesnocancel(char *txt,char *title,MsgBoxIcon mbi) {
  GtkWidget *yndlg,*yes,*no,*cancel,*lb,*tbl,*hs;

  GdkBitmap *mask;
  GdkPixmap *dqmark;
  GtkWidget *tqmark;
  GtkStyle *style;
  
  ync.answer_available=FALSE;

  yndlg=gtk_window_new(GTK_WINDOW_DIALOG);
  tbl=gtk_table_new(3,4,FALSE);
  gtk_container_add(GTK_CONTAINER(yndlg),tbl);
  gtk_window_set_title(GTK_WINDOW(yndlg),title);
  gtk_container_set_border_width(GTK_CONTAINER(yndlg),4);
  GTK_WINDOW(yndlg)->position=GTK_WIN_POS_CENTER;
  gtk_window_set_policy(GTK_WINDOW(yndlg),TRUE,TRUE,TRUE); /* 0.3.6 */
  gtk_widget_show(yndlg);  

  style=gtk_widget_get_style(yndlg);

  if (mbi!=MSGBOX_ICON_NONE) {
    dqmark=gdk_pixmap_create_from_xpm_d(yndlg->window,&mask,
					&style->bg[GTK_STATE_NORMAL],mb_icons[mbi]);
    tqmark=gtk_pixmap_new(dqmark,mask);
    gtk_table_attach(GTK_TABLE(tbl),tqmark,0,1,0,1,GTK_FILL,GTK_FILL,5,5);
    gtk_widget_show(tqmark);
  }

  lb=gtk_label_new(txt);
  gtk_label_set_justify(GTK_LABEL(lb),GTK_JUSTIFY_LEFT);
  gtk_table_attach(GTK_TABLE(tbl),lb,1,4,0,1,GTK_FILL,GTK_FILL,10,10);
  gtk_widget_show(lb);

  hs=gtk_hseparator_new();
  gtk_table_attach(GTK_TABLE(tbl),hs,0,4,1,2,GTK_FILL,GTK_FILL,0,10);
  gtk_widget_show(hs);

  yes=gtk_button_new_with_label("Yes");
  no=gtk_button_new_with_label("No");
  cancel=gtk_button_new_with_label("Cancel");
  gtk_table_attach(GTK_TABLE(tbl),yes,1,2,2,3,GTK_FILL,GTK_FILL,2,2);
  gtk_table_attach(GTK_TABLE(tbl),no,2,3,2,3,GTK_FILL,GTK_SHRINK,2,2);
  gtk_table_attach(GTK_TABLE(tbl),cancel,3,4,2,3,GTK_FILL,GTK_SHRINK,2,2);
  GTK_WIDGET_SET_FLAGS(yes,GTK_CAN_DEFAULT);
  gtk_widget_grab_default(yes);
  gtk_widget_show(yes);
  gtk_widget_show(no);
  gtk_widget_show(cancel);

  gtk_signal_connect(GTK_OBJECT(yes),"clicked",
		     GTK_SIGNAL_FUNC(message_box_yesnocancel_yes),NULL);
  gtk_signal_connect(GTK_OBJECT(no),"clicked",
		     GTK_SIGNAL_FUNC(message_box_yesnocancel_no),NULL);
  gtk_signal_connect(GTK_OBJECT(cancel),"clicked",
		     GTK_SIGNAL_FUNC(message_box_yesnocancel_cancel),NULL);
  gtk_signal_connect(GTK_OBJECT(yndlg),"delete_event",
		     GTK_SIGNAL_FUNC(immortal),NULL);
  gtk_widget_show(tbl);
  gtk_grab_add(yndlg);

  while(!ync.answer_available)
    gtk_main_iteration();

  gtk_grab_remove(yndlg);
  gtk_widget_destroy(yndlg);

  return(ync.answer);
}

gint message_box_yesno(char *txt,char *title,MsgBoxIcon mbi) {
  GtkWidget *yndlg,*yes,*no,*lb,*tbl,*hs;
  GdkBitmap *mask;
  GdkPixmap *dqmark;
  GtkWidget *tqmark;
  GtkStyle *style;
  
  ync.answer_available=FALSE;

  yndlg=gtk_window_new(GTK_WINDOW_DIALOG);
  tbl=gtk_table_new(3,4,FALSE);
  gtk_container_add(GTK_CONTAINER(yndlg),tbl);
  gtk_window_set_title(GTK_WINDOW(yndlg),title);
  gtk_container_set_border_width(GTK_CONTAINER(yndlg),4);
  GTK_WINDOW(yndlg)->position=GTK_WIN_POS_CENTER;
  gtk_window_set_policy(GTK_WINDOW(yndlg),TRUE,TRUE,TRUE); /* 0.3.6 */
  gtk_widget_show(yndlg);  

  lb=gtk_label_new(txt);
  gtk_label_set_justify(GTK_LABEL(lb),GTK_JUSTIFY_LEFT);
  gtk_table_attach(GTK_TABLE(tbl),lb,1,4,0,1,GTK_FILL,GTK_FILL,10,10);
  gtk_widget_show(lb);

  style=gtk_widget_get_style(yndlg);

  if (mbi!=MSGBOX_ICON_NONE) {
    dqmark=gdk_pixmap_create_from_xpm_d(yndlg->window,&mask,
					&style->bg[GTK_STATE_NORMAL],mb_icons[mbi]);
    tqmark=gtk_pixmap_new(dqmark,mask);    
    gtk_table_attach(GTK_TABLE(tbl),tqmark,0,1,0,1,GTK_FILL,GTK_FILL,5,5);
    gtk_widget_show(tqmark);
  }

  hs=gtk_hseparator_new();
  gtk_table_attach(GTK_TABLE(tbl),hs,0,4,1,2,GTK_FILL,GTK_FILL,0,10);
  gtk_widget_show(hs);

  yes=gtk_button_new_with_label("Yes");
  no=gtk_button_new_with_label("No");
  gtk_table_attach(GTK_TABLE(tbl),yes,2,3,2,3,GTK_FILL,GTK_FILL,2,2);
  gtk_table_attach(GTK_TABLE(tbl),no,3,4,2,3,GTK_FILL,GTK_SHRINK,2,2);
  GTK_WIDGET_SET_FLAGS(yes,GTK_CAN_DEFAULT);
  gtk_widget_grab_default(yes);
  gtk_widget_show(yes);
  gtk_widget_show(no);

  gtk_signal_connect(GTK_OBJECT(yes),"clicked",
		     GTK_SIGNAL_FUNC(message_box_yesnocancel_yes),NULL);
  gtk_signal_connect(GTK_OBJECT(no),"clicked",
		     GTK_SIGNAL_FUNC(message_box_yesnocancel_no),NULL);
  gtk_signal_connect(GTK_OBJECT(yndlg),"delete_event",
		     GTK_SIGNAL_FUNC(immortal),NULL);
  gtk_widget_show(tbl);

  gtk_grab_add(yndlg);

  while(!ync.answer_available)
    gtk_main_iteration();

  gtk_grab_remove(yndlg);
  gtk_widget_destroy(yndlg);

  return(ync.answer);
}

void message_box_yesnocancel_yes(GtkWidget *widget,gpointer data) {
  ync.answer=MSG_YES;
  ync.answer_available=TRUE;
}

void message_box_yesnocancel_no(GtkWidget *widget,gpointer data) {
  ync.answer=MSG_NO;
  ync.answer_available=TRUE;
}

void message_box_yesnocancel_cancel(GtkWidget *widget,gpointer data) {
  ync.answer=MSG_CANCEL;
  ync.answer_available=TRUE;
}

gint message_box_ok(char *txt,char *title,MsgBoxIcon mbi) {
  GtkWidget *yndlg,*ok,*lb,*tbl,*hs;
  GdkBitmap *mask;
  GdkPixmap *dqmark;
  GtkWidget *tqmark;
  GtkStyle *style;
  
  okd.answer_available=FALSE;

  yndlg=gtk_window_new(GTK_WINDOW_DIALOG);
  tbl=gtk_table_new(3,4,FALSE);
  gtk_container_add(GTK_CONTAINER(yndlg),tbl);
  gtk_window_set_title(GTK_WINDOW(yndlg),title);
  gtk_container_set_border_width(GTK_CONTAINER(yndlg),4);
  GTK_WINDOW(yndlg)->position=GTK_WIN_POS_CENTER;
  gtk_window_set_policy(GTK_WINDOW(yndlg),TRUE,TRUE,TRUE); /* 0.3.6 */
  gtk_widget_show(yndlg);  

  lb=gtk_label_new(txt);
  gtk_label_set_justify(GTK_LABEL(lb),GTK_JUSTIFY_LEFT);
  gtk_table_attach(GTK_TABLE(tbl),lb,1,4,0,1,GTK_FILL,GTK_FILL,10,10);
  gtk_widget_show(lb);

  style=gtk_widget_get_style(yndlg);

  if (mbi!=MSGBOX_ICON_NONE) {
    dqmark=gdk_pixmap_create_from_xpm_d(yndlg->window,&mask,
					&style->bg[GTK_STATE_NORMAL],mb_icons[mbi]);
    tqmark=gtk_pixmap_new(dqmark,mask);
    gtk_table_attach(GTK_TABLE(tbl),tqmark,0,1,0,1,GTK_FILL,GTK_FILL,5,5);
    gtk_widget_show(tqmark);
  }

  hs=gtk_hseparator_new();
  gtk_table_attach(GTK_TABLE(tbl),hs,0,4,1,2,GTK_FILL,GTK_FILL,0,10);
  gtk_widget_show(hs);

  ok=gtk_button_new_with_label("OK");
  gtk_table_attach(GTK_TABLE(tbl),ok,3,4,2,3,GTK_FILL,GTK_SHRINK,2,2);
  GTK_WIDGET_SET_FLAGS(ok,GTK_CAN_DEFAULT);
  gtk_widget_grab_default(ok);
  gtk_widget_show(ok);

  gtk_signal_connect(GTK_OBJECT(ok),"clicked",
		     GTK_SIGNAL_FUNC(message_box_ok_ok),NULL);
  gtk_signal_connect(GTK_OBJECT(yndlg),"delete_event",
		     GTK_SIGNAL_FUNC(immortal),NULL);
  gtk_widget_show(tbl);

  gtk_grab_add(yndlg);

  while(!okd.answer_available)
    gtk_main_iteration();

  gtk_grab_remove(yndlg);
  gtk_widget_destroy(yndlg);

  return(MSG_YES);
}

void message_box_ok_ok(GtkWidget *widget,gpointer data) {
  okd.answer_available=TRUE;
}

gint immortal(GtkWidget *widget,GdkEvent *event,gpointer data) {
  return TRUE;
}

