#include "diawxxt.h"

PUBLIC HLINE::HLINE (MFORM *_parent, const char *_s)
	: wxPanel (_parent)
{
	if (_s == NULL || _s[0] == '\0'){
		s = NULL;
		pref_width = (int)GetCharWidth();
		pref_height = (int)GetCharHeight();
	}else{
		s = strdup(_s);
		float w,h;
		dc->GetTextExtent (s,&w,&h);
		pref_width = (int)w;
		pref_width += (int)dc->GetCharWidth();
		pref_height = (int)h;
	}
	SetClientSize (pref_width+4,pref_height+4);
}

PUBLIC HLINE::~HLINE ()
{
	free ((char*)s);
}

PRIVATE void HLINE::draw3dline (wxDC *dc, int x, int y, int end)
{
	dc->SetPen (pen_black);
	dc->DrawLine (x,y,end,y);
	dc->SetPen (pen_white);
	y++;
	dc->DrawLine (x+1,y,end,y);
}
PUBLIC void HLINE::OnPaint ()
{
	int wx,wy;
	GetPosition (&wx,&wy);
	int cur_width,cur_height;
	GetSize (&cur_width,&cur_height);
	int y = cur_height/2;
	if (s == NULL || s[0] == '\0'){
		draw3dline (dc,0,y,cur_width);
	}else{
		int side = (cur_width - pref_width) /2;
		dc->SetPen (pen_black);
		dc->DrawText (s,side+(int)(dc->GetCharWidth()/2),y-GetCharHeight()/2);
		draw3dline (dc,0,y,side);
		draw3dline (dc,cur_width-side,y,cur_width);
	}
}

