#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>

/*
	sgml2txt produce nice ASCII text, but still produce
	some features such as overstike and underline.

	Linuxconf's help support it. Some viewer do not.
	This program read a sgml translated file and write
	a file without those features
*/

static FILE *myfopen (const char *fname, const char *mode)
{
	FILE *ret = fopen (fname,mode);
	if (ret == NULL){
		fprintf (stderr,"Can't open file %s: %s\n"
			,fname,strerror(errno));
		exit (-1);
	}
	return ret;
}
int main (int argc, char *argv[])
{
	int ret = -1;
	if (argc != 3){
		fprintf (stderr,
			"sgml2flat sourcefile destinationfile\n"
			"source and destination CAN'T be the same\n");
	}else{
		FILE *fin = myfopen (argv[1],"r");
		FILE *fout = myfopen (argv[2],"w");
		char buf[500];
		while (fgets(buf,sizeof(buf)-1,fin)!=NULL){
			char buf2[500];
			char *pts = buf;
			char *ptd = buf2;
			while (*pts != '\0'){
				if (pts[1] == 8){
					pts += 2;
				}else if (pts[0] == 0xad){
					pts[0] = '-';
				}
				if (*pts == '\0') break;
				*ptd++ = *pts++;
			}
			*ptd = '\0';
			fputs (buf2,fout);
		}
		fclose (fin);
		ret = fclose (fout);
	}
	return ret;
}
