#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <sys/stat.h>
#include <misc.h>
#include "xconf.h"
#include "components.h"

#if 0
void xconf_opt2opt2(
	char *tbopt[],
	int nbopt,
	char *tbopt2[])
{
	int nb2 = 0;
	/* #Specification: files / adaptor.conf & screen.conf
		Each configuration line in adaptor.conf is interpreted this way.
		If it start in first column, then the first word identify the
		supplier and the rest of the line identify a specific product.

		If it start with a white character (space, tabs), it is assume
		that it is another product of the same supplier and the supplier
		name won't be repeated.

		This allows presentation like this

			ibm		model 25
					model 30
			ati		mach32 ultra
					mac32 ultra

		If there is only one word in the line, then it will be shown
		in the first column of the selection list.
	*/
	for (int i=0; i<nbopt; i++){
		char *opt = tbopt[i];
		char *opt1 = " ";
		char *opt2 = " ";
		if (isspace(opt[0])){
			char *pt = opt;
			while (isspace(*pt)) pt++;
			opt2 = pt;
		}else{
			char *pt = opt;
			while (*pt > ' ') pt++;
			if (isspace (*pt)){
				*pt++ = '\0';
				while (isspace(*pt)) pt++;
				opt1 = opt;
				opt2 = pt;
			}else{
				opt1 = opt;
			}
		}
		tbopt2[nb2++] = opt1;
		tbopt2[nb2++] = opt2;
	}
	tbopt2[nb2] = NULL;
}
#endif
/*
	Read many (potentially none) component files in a directory dir
	using wildcard wild.
	Return the number of files read.
	Return -1 if any kind of error.
*/
int xconf_readconf(
	COMPONENTS &comp,
	const char *dir,
	const char *wild)
{
	int ret = 0;
	int err = 0;
	char cmd[300];
	sprintf (cmd,"echo %s/%s",dir,wild);
	FILE *fin = popen (cmd,"r");
	if (fin != NULL){
		char buf[PATH_MAX];
		while (fgets (buf,sizeof(buf)-1,fin)!=NULL){
			str_strip (buf,buf);
			struct stat sbuf;
			if (buf[0] != '\0' && stat(buf,&sbuf)!=-1){
				ret++;
				err |= comp.read (buf);
			}
		}
		pclose (fin);
	}else{
		xconf_error ("Can't execute command\n%s\n(%s)\n",cmd
			,strerror(errno));
	}
	return err == 0 ? ret : -1;
}
/*
	Read many (potentially none) component files in the current directory
	and in the USR_LIB_XCONF directory using wildcard wild.
	Return the number of files read.
	Return -1 if any kind of error.
*/
int xconf_readconfall(
	COMPONENTS &comp,
	const char *wild1,
	const char *wild2)
{
	/* #Specification: data files / locations
		Configuration file (database files) are search in the current
		directory and in the USR_LIB_XCONF directory. The first one
		is there mostly to help people experiment with xconf.

		All files located are merged and sorted in memory.

		The merge is mostly an addition. No precedence is done
		to eliminate duplicated entries.
	*/
	int ret1 = xconf_readconf (comp,".",wild1);
	int ret2 = xconf_readconf (comp,".",wild2);
	int ret3 = xconf_readconf (comp,USR_LIB_XCONF,wild1);
	int ret4 = xconf_readconf (comp,USR_LIB_XCONF,wild2);
	comp.sort();
	int ret = ret1 + ret2 + ret3 + ret4;
	if (ret1 == -1 || ret2 == -1 || ret3 == -1 || ret4 == -1){
		ret = -1;
	}
	return ret;
}
/*
	Select an adaptor type and program the different option necessary.
*/
int xconf_adaptor (XCONFIG &xcfg)
{
	COMPONENTS comp;
	xconf_readconfall (comp,"adaptors.xconf","adaptors.*.xconf");
	char *tbopt2[4001];
	int nbopt = comp.setmenu (tbopt2);
	int ret = 0;
	if (nbopt > 0){
		int choice = 0;
		xconf_menu ("Adaptor list"
			,"You must select an adaptor from this list\n"
			 "The list is sorted by manufacturer\n"
			 "and product"
			,tbopt2,choice);
		if (choice != -1){
			COMPONENT *compo = comp.item(choice);
			xcfg.addcomment ("Adaptor",compo->keyw,compo->arg);
			xcfg.merge (compo->xconfig);
			xconf_notice (compo->notice);
		}
	}else{
		xconf_error (
			"No sadaptors.xconf file could be found\n"
			"either in the current directory or in\n"
			"the directory %s\n"
			,USR_LIB_XCONF);
		ret = -1;
	}
	return ret;
}

