# copyright (C) 1997-1999 Jean-Luc Fontaine (mailto:jfontain@multimania.com)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: lifolbl.tcl,v 2.1 1999/08/28 08:33:26 jfontain Exp $}

# last-in-first-out label generally used at the bottom of an application window for messages display

source xifo.tcl

class lifoLabel {}

proc lifoLabel::lifoLabel {this parentPath args} composite {
    [new frame $parentPath -relief sunken -borderwidth $widget::(default,ButtonBorderWidth)] $args
} {
    set path $widget::($this,path)
    composite::manage $this [new label $path -font {helvetica -12 bold} -text Message:] header [new frame $path] separator\
        [new label $path -font {helvetica -12} -anchor w] body
    pack $composite::($this,header,path) $composite::($this,separator,path) -side left
    pack $composite::($this,body,path) -fill x -expand 1
    set ($this,lifo) [new lifo]
    composite::complete $this
}

proc lifoLabel::~lifoLabel {this} {
    delete $($this,lifo)
}

proc lifoLabel::options {this} {
    return [list\
        [list -borderwidth borderWidth BorderWidth $widget::(default,ButtonBorderWidth) $widget::(default,ButtonBorderWidth)]\
        [list -font font Font {helvetica -12} {helvetica -12}]\
        [list -header header Text Message: Message:]\
        [list -headerfont headerFont Font {helvetica -12 bold} {helvetica -12 bold}]\
        [list -relief relief Relief sunken sunken]\
        [list -spacing spacing Spacing 0 0]\
    ]
}

foreach option {-borderwidth -relief} {
    proc lifoLabel::set$option {this value} "\$widget::(\$this,path) configure $option \$value"
}

proc lifoLabel::set-font {this value} {
    $composite::($this,body,path) configure -font $value
}

proc lifoLabel::set-headerfont {this value} {
    $composite::($this,header,path) configure -font $value
}

proc lifoLabel::set-header {this value} {
    $composite::($this,header,path) configure -text $value
}

proc lifoLabel::set-spacing {this value} {
    $composite::($this,separator,path) configure -width $value
}

proc lifoLabel::push {this string} {                                                          ;# user procedure for pushing a string
    if {[string length [set current [$composite::($this,body,path) cget -text]]]>0} {  ;# store current string in stack if non empty
        xifo::in $($this,lifo) $current
    }
    $composite::($this,body,path) configure -text $string
}

proc lifoLabel::pop {this} {                                                                  ;# user procedure for popping a string
    set string {}
    catch {set string [lifo::out $($this,lifo)]}
    $composite::($this,body,path) configure -text $string                                           ;# set label text (may be empty)
    return $string
}

proc lifoLabel::flash {this string {seconds 1}} {                                            ;# user procedure for flashing a string
    after [expr {1000*$seconds}] lifoLabel::pop $this
    push $this $string
}
