# copyright (C) 1997-1999 Jean-Luc Fontaine (mailto:jfontain@multimania.com)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: network.tcl,v 1.2 1999/07/23 21:19:06 jfontain Exp $}

package provide network 1.3

namespace eval network {

    proc parseRemoteLocator {string} {                                                                  ;# return user and host list
        set string [string trim $string]
        if {[string match *@* $string]} {                                                                     ;# user@host specified
            return [split $string @]
        } else {                                                                                              ;# only host specified
            return [list $::env(USER) $string]                                                                   ;# use current user
        }
    }

    proc checkRemoteOutputEmptiness {host} {
        catch "exec /usr/bin/rsh $host test" output
        if {[string length $output]>0} {
            puts stderr "remote host \"$host\" shell output should be empty, got instead:"
            puts stderr $output
            exit 1
        }
    }

}
