/* -------------------------------------------------------------------- */
/* SMS Client, send messages to mobile phones and pagers		*/
/*									*/
/* tim.c								*/
/*									*/
/*  Copyright (C) 1997,1998,1999 Angelo Masci				*/
/*									*/
/*  This library is free software; you can redistribute it and/or	*/
/*  modify it under the terms of the GNU Library General Public		*/
/*  License as published by the Free Software Foundation; either	*/
/*  version 2 of the License, or (at your option) any later version.	*/
/*									*/
/*  This library is distributed in the hope that it will be useful,	*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of	*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU	*/
/*  Library General Public License for more details.			*/
/*									*/
/*  You should have received a copy of the GNU Library General Public	*/
/*  License along with this library; if not, write to the Free		*/
/*  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.	*/
/*									*/
/*  You can contact the author at this e-mail address:			*/
/*									*/
/*  angelo@styx.demon.co.uk						*/
/*									*/
/*  the author of this module						*/
/*  massimo@nuvoli.to.it   						*/
/*  adapted by 								*/
/*  adrieder@sbox.tu-graz.ac.at						*/
/* -------------------------------------------------------------------- */
/* $Id: tim.c,v A.0 1999/08/11 16:00:00 root Exp root $
   -------------------------------------------------------------------- */

#include <stdio.h>
#include <string.h>

#include "common/common.h"
#include "logfile/logfile.h"
#include "driver.h"
#include "error.h"
#include "comms/comms.h"
#include "resource/resource.h"

/* -------------------------------------------------------------------- */

static char ACK1[] = "Collegamento OK";
static char ACK2[] = "per scollegarsi";
static char ACK3[] = "telefonino";
static char ACK4[] = "messaggio";
static char ACK5[] = "(max 160 car.) :\r\r\n";
static char ACK51[] = "Invio";
static char ACK6[] = "centri TIM";
static char ACK7[] = "MESSAGGIO INVIATO";
static char ACK8[] = "[Y]";



/*
static char ACK2[] = "8 per inviare";
static char ACK3[] = "Destinatario del messaggio";
static char ACK4[] = "Testo messaggio";
static char ACK5[] = "Invio messaggio";
static char ACK6[] = "VT200";
static char ACK7[] = "per scollegarsi";
static char ACK8[] = "centri TIM";
static char ACK9[] = "Fine sessione       <S, N>";
static char ACKA[] = "Premere INVIO per continuare.";
*/


/* -------------------------------------------------------------------- */

static struct tim_env
{
	DRIVER_DEFAULT_ENV def;

	/* Place any extended driver	*/ 
	/* variables here 		*/

} driver_env;

/* -------------------------------------------------------------------- */

static 	RESOURCE resource_list[] = 
	{
		{ RESOURCE_STRING,  "SMS_comms_params", 	0, 1, NULL, 0,  "8N1",  0, 	 &(driver_env.def.comms_params)  	},
		{ RESOURCE_STRING,  "SMS_centre_number", 	0, 1, NULL, 0,  NULL,   0, 	 &(driver_env.def.centre_number)  	},
		{ RESOURCE_NUMERIC, "SMS_baud", 		0, 1, NULL, 0,  NULL,   9600, 	 &(driver_env.def.baud)  		},
		{ RESOURCE_NUMERIC, "SMS_deliver_timeout", 	0, 0, NULL, 0,  NULL,   30, 	 &(driver_env.def.deliver_timeout)  	},
		{ RESOURCE_NUMERIC, "SMS_timeout", 		0, 0, NULL, 0,  NULL,   20, 	 &(driver_env.def.timeout)  		},
		{ RESOURCE_NUMERIC, "SMS_write_timeout", 	0, 0, NULL, 0,  NULL,   10, 	 &(driver_env.def.write_timeout)  	},
		{ RESOURCE_NUMERIC, "SMS_max_deliver", 		0, 0, NULL, 0,  NULL,   0,    	 &(driver_env.def.max_deliver)  	},
		{ RESOURCE_NULL,     NULL, 			0, 1, NULL, 0,  NULL,   0, 	 NULL  					}
	};

/* -------------------------------------------------------------------- */

#define DELIVERTIMEOUT 		(driver_env.def.deliver_timeout)
#define TIMEOUT 		(driver_env.def.timeout)
#define WRITETIMEOUT 		(driver_env.def.write_timeout)

/* -------------------------------------------------------------------- */

#define FD			(driver_env.def.fd)

/* -------------------------------------------------------------------- */

static int TIM_login(void);
static int TIM_sendmessage(char *msisdn, char *message);
static int TIM_send_disconnect(void);
static void TIM_hangup(void);

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
static int TIM_login(void)
{
	char buf[MAX_RESPONSE_BUFSIZE];


	if (expstr(FD, buf, ACK1, MAX_RESPONSE_BUFSIZE, TIMEOUT) == 0)
	{
		lprintf(LOG_STANDARD, "Tim Service Login\n");
	}
	else
	{	lprintf(LOG_STANDARD, "No Tim Service Login\n");
		
		TIM_hangup();
		return ETIM_NORESPONSE;
	}

        if (expstr(FD, buf, ACK2, MAX_RESPONSE_BUFSIZE, TIMEOUT) == 0)
        {
                lprintf(LOG_STANDARD, "Tim Service Login\n");
        }
        else
        {
                lprintf(LOG_STANDARD, "No Tim Service Response\n");

                TIM_hangup();
                return ETIM_NORESPONSE;
        }

        twrite(FD, "1\r\n", sms_strlen("1\r\n"), WRITETIMEOUT);
	if (expstr(FD, buf, ACK3, MAX_RESPONSE_BUFSIZE, TIMEOUT) == 0)
        {
                lprintf(LOG_STANDARD, "Tim Service Terminal\n");
        }
        else
        {
                lprintf(LOG_STANDARD, "No Tim Service Response\n");

                TIM_hangup();
                return ETIM_NORESPONSE;
        }
        if (expstr(FD, buf, ACK2, MAX_RESPONSE_BUFSIZE, TIMEOUT) == 0)
        {
                lprintf(LOG_STANDARD, "Tim Service Terminal\n");
        }
        else
        {
                lprintf(LOG_STANDARD, "No Tim Service Response\n");

                TIM_hangup();
                return ETIM_NORESPONSE;
        }

        twrite(FD, "1\r\n", sms_strlen("1\r\n"), WRITETIMEOUT);
	if (expstr(FD, buf, ACK6, MAX_RESPONSE_BUFSIZE, TIMEOUT) == 0)
        {
                lprintf(LOG_STANDARD, "Tim Service Menu\n");
        }
        else
        {
                lprintf(LOG_STANDARD, "No Tim Service Menu\n");

                TIM_hangup();
                return ETIM_NORESPONSE;
        }
	if (expstr(FD, buf, ACK2, MAX_RESPONSE_BUFSIZE, TIMEOUT) == 0)
        {
                lprintf(LOG_STANDARD, "Tim Service Menu\n");
        }
        else
        {
                lprintf(LOG_STANDARD, "No Tim Service Menu\n");

                TIM_hangup();
                return ETIM_NORESPONSE;
        }
/*
        twrite(FD, "1\r\n", sms_strlen("1\r\n"), WRITETIMEOUT);
        if (expstr(FD, buf, ACK1, MAX_RESPONSE_BUFSIZE, TIMEOUT) == 0)
        {
                lprintf(LOG_STANDARD, "Tim Service Terminal\n");
        }
        else
        {
                lprintf(LOG_STANDARD, "No Tim Service Response\n");

                TIM_hangup();
                return ETIM_NORESPONSE;
        }

        if (expstr(FD, buf, ACK2, MAX_RESPONSE_BUFSIZE, TIMEOUT) == 0)
        {
                lprintf(LOG_STANDARD, "Tim Menu Request\n");
        }
        else
        {
                lprintf(LOG_STANDARD, "No Tim Menu Request\n");

                TIM_hangup();
                return ETIM_NORESPONSE;
        }
*/	
	return 0;
}

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
static int TIM_sendmessage(char *msisdn, char *message)
{
	char buf[MAX_RESPONSE_BUFSIZE];


	twrite(FD, "1\r\n", sms_strlen("1\r\n"), WRITETIMEOUT);
	if (expstr(FD, buf, ACK4, MAX_RESPONSE_BUFSIZE, TIMEOUT) == 0)
	{
		lprintf(LOG_STANDARD, "Received Number Request\n");
	}
	else
	{	lprintf(LOG_STANDARD, "No Number Request\n");
		
		TIM_hangup();
		return ETIM_NONUMBER;
	}


	twrite(FD, msisdn, sms_strlen(msisdn), WRITETIMEOUT);

	twrite(FD, "\n\n\n\n\n", sms_strlen("\n\n\n\n\n"), WRITETIMEOUT);
	if (expstr(FD, buf, ACK5, MAX_RESPONSE_BUFSIZE, TIMEOUT) == 0)
	{
		lprintf(LOG_STANDARD, "Received Message Request\n");
	}
	else
	{	lprintf(LOG_STANDARD, "No Message Request\n");
		
		TIM_hangup();
		return ETIM_NOMESSAGE;
	}

	twrite(FD, message, sms_strlen(message), WRITETIMEOUT);
	twrite(FD, "\n", sms_strlen("\n"), WRITETIMEOUT);

	if (expstr(FD, buf, ACK51, MAX_RESPONSE_BUFSIZE, TIMEOUT) == 0)
	{
		lprintf(LOG_STANDARD, "Received Delivery Request\n");
	}
	else
	{	lprintf(LOG_STANDARD, "No Delivery Request\n");
		
		TIM_hangup();
		return ETIM_NOMESSAGE;
	}

	
	twrite(FD, "\r\n", sms_strlen("\r\n"), WRITETIMEOUT);

	if (expstr(FD, buf, ACK7, MAX_RESPONSE_BUFSIZE, DELIVERTIMEOUT) == 0)
	{
		lprintf(LOG_STANDARD, "Received Message Delivery Response\n");
	}
	else
	{	lprintf(LOG_STANDARD, "No Message Delivery Response\n");
		
		TIM_hangup();
		return ETIM_NODELIVERY;
	}
/*
	twrite(FD, "8\r\n", sms_strlen("8\r\n"), WRITETIMEOUT);
	if (expstr(FD, buf, ACK5, MAX_RESPONSE_BUFSIZE, DELIVERTIMEOUT) == 0)
	{
		lprintf(LOG_STANDARD, "Received Message Delivery Response\n");
	}
	else
	{	lprintf(LOG_STANDARD, "No Message Delivery Response\n");
		
		TIM_hangup();
		return ETIM_NODELIVERY;
	}

	twrite(FD, "S\r\n", sms_strlen("S\r\n"), WRITETIMEOUT);
	if (expstr(FD, buf, ACKA, MAX_RESPONSE_BUFSIZE, DELIVERTIMEOUT) == 0)
	{
		lprintf(LOG_STANDARD, "Received Message Delivery Response\n");
	}
	else
	{	lprintf(LOG_STANDARD, "No Message Delivery Response\n");
		
		TIM_hangup();
		return ETIM_NODELIVERY;
	}

	twrite(FD, "\r\n", sms_strlen("\r\n"), WRITETIMEOUT);

	if (expstr(FD, buf, ACK2, MAX_RESPONSE_BUFSIZE, DELIVERTIMEOUT) == 0)
	{
		lprintf(LOG_STANDARD, "Received Message Delivery Response\n");
	}
	else
	{	lprintf(LOG_STANDARD, "No Message Delivery Response\n");
		
		TIM_hangup();
		return ETIM_NODELIVERY;
	}
	
*/
/*
	twrite(FD, "q", sms_strlen("q"), WRITETIMEOUT);
	twrite(FD, "y", sms_strlen("y"), WRITETIMEOUT);
*/

	return 0;
}

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
static int TIM_send_disconnect(void)
{
	char buf[MAX_RESPONSE_BUFSIZE];


	twrite(FD, "q", sms_strlen("q"), WRITETIMEOUT);

	if (expstr(FD, buf, ACK8, MAX_RESPONSE_BUFSIZE, TIMEOUT) == 0)
	{
		lprintf(LOG_STANDARD, "Received Disconnection Response\n");
	}
	else
	{	lprintf(LOG_STANDARD, "No Disconnection Response\n");
		
		TIM_hangup();
		return ETIM_NODISCONNECT;
	}

	twrite(FD, "y", sms_strlen("y"), WRITETIMEOUT);
/*
	if (expstr(FD, buf, ACK9, MAX_RESPONSE_BUFSIZE, TIMEOUT) == 0)
	{
		lprintf(LOG_STANDARD, "Received Disconnection Response\n");
	}
	else
	{	lprintf(LOG_STANDARD, "No Disconnection Response\n");
		
		TIM_hangup();
		return ETIM_NODISCONNECT;
	}

	twrite(FD, "S\r\n", sms_strlen("S\r\n"), WRITETIMEOUT);
*/
	return 0;
}

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
static void TIM_hangup(void)
{	default_hangup((DRIVER_DEFAULT_ENV *)(&driver_env));
}

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
DEVICE_ENTRY tim_device = {

	"TIM",
	"1.1",
	resource_list,
	(DRIVER_DEFAULT_ENV *)(&driver_env),

	default_init,
	default_main,
	default_validate_numeric_id,
	default_dial,
	default_hangup,
	TIM_send_disconnect,
	default_multiple_counted_deliver,
	TIM_sendmessage,
	TIM_login
};

