/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */

#include "common/common.h"

#include "gs_token.h"
#include "gs_list.h"
#include "gs_translate.h"
#include "gs_parser.h"

#include "gs_getdict.h"

/* -------------------------------------------------------------------- */
/*									*/
/* Return Values:							*/
/*									*/
/* 	Token of type 'Identifier', 'Dictionary' or 'List' or		*/
/* 	NULL if an error ocuured.					*/
/*									*/
/*	*ptr is set to NULL when we are at the end of the list.		*/
/*									*/
/* -------------------------------------------------------------------- */
TOKEN *gs_get_dictionary_next(TOKEN *item, TOKEN_LIST **ptr)
{
	TOKEN_HEAP 
		*heap;
	TOKEN_LIST	
		*list;
	TOKEN	*token;



	if (! gs_isdictionary(item))
	{
		return NULL;
	}

	if (*ptr == NULL)
	{
		heap = (TOKEN_HEAP *)(item->ptr);
		if (heap == NULL)
		{
			return NULL;
		}

		list = (TOKEN_LIST *)(heap->list);
		if (list == NULL)
		{
			return NULL;
		}
	}
	else
	{	list = *ptr;
	}


	while ((list != NULL) && (gs_isdata(list->token)))
	{
		/* Skip ALL items which are simply	*/
		/* Data. We only want to return		*/
		/* 'Identifiers', 'Dictionaries' or 	*/
		/* 'Lists'				*/

		list = list->next;
	}

	token = list->token;
	if (token == NULL)
	{
		return NULL;
	}
	
	*ptr = list->next;
	return token;
}


