#include <stdio.h>
#include <stdlib.h>

#include "gs_token.h"
#include "gs_list.h"
#include "gs_load.h"

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
int gs_loaddictionaryfromfile(char *filename, TOKEN *dictionary)
{
	TOKEN_HEAP 
		*heap;

	TOKEN	*token_id;


	if (! gs_isdictionary(dictionary))
	{	return -1;
	}


	init_builtin_heap();
	heap = get_token_indirect_dictionary(NULL, dictionary);
	if (heap == NULL)
	{	return -1;
	}

	if (gs_open(filename))
	{	return -1;
	}

	if (parse_dictionary(heap))
	{
		token_id = get_next_token(heap);
		if (token_id != eof_tok)
		{
			gs_close();
			return -1;
		}
	}
	else
	{	gs_close();
		return -1;
	}
	
	if (gs_close())
	{	return -1;
	}

	return 0;
}

